/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.antcloud.rest;

import cn.com.antcloud.api.common.BaseClientRequest;
import cn.com.antcloud.api.common.GwSignType;
import cn.com.antcloud.api.common.SDKUtils;
import cn.com.antcloud.api.rest.RestHeaders;
import cn.com.antcloud.api.rest.RestHttpMethod;
import java.util.HashMap;
import java.util.Map;

public class AntCloudRestClientRequest
extends BaseClientRequest {
    private String urlPath;
    private RestHttpMethod httpMethod;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private String postBody;

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public RestHttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(RestHttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public String getPostBody() {
        return this.postBody;
    }

    public void setPostBody(String postBody) {
        this.postBody = postBody;
    }

    public void putHeader(String key, String value) {
        SDKUtils.checkNotNull(key);
        this.headers.put(key, value);
    }

    public String getHeaderValue(String key) {
        return this.headers.get(key);
    }

    public void putQueryParam(String key, String value) {
        SDKUtils.checkNotNull(key);
        this.queryParams.put(key, value);
    }

    public void setAuthToken(String authToken) {
        this.headers.put("X-AntCloud-Auth-Token", authToken);
    }

    public void setProductInstanceId(String productInstanceId) {
        this.headers.put("X-AntCloud-Product-Instance-Id", productInstanceId);
    }

    public String getProductInstanceId() {
        return this.headers.get("X-AntCloud-Product-Instance-Id");
    }

    public void setRegionName(String regionName) {
        this.headers.put("X-AntCloud-Region-Name", regionName);
    }

    public String getRegionName() {
        return this.headers.get("X-AntCloud-Region-Name");
    }

    public void setApiVersion(String apiVersion) {
        this.headers.put("X-AntCloud-Api-Version", apiVersion);
    }

    public String getApiVersion() {
        return this.headers.get("X-AntCloud-Api-Version");
    }

    public Map<String, String> getSignHeaders() {
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        for (String signHeader : RestHeaders.SIGN_HEADERS) {
            signHeaders.put(signHeader, this.headers.get(signHeader));
        }
        return signHeaders;
    }

    public void setSignType(GwSignType gwSignType) {
        this.headers.put("X-AntCloud-Sign-Type", gwSignType.name());
    }
}

