/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.common;

import cn.com.antcloud.api.common.GwSigns;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class GwRestSignUtils {
    private static final String LINE_DELIMITER = "\n";
    private static final String HEADER_DELIMITER = ":";
    private static final String DEFAULT_STRING = "";
    private static final String URL_DELIMITER = "/";

    public static String getStringToSign(String uri, String httpMethod, Map<String, String> signHeaders, Map<String, String> queryParams, String rawPostJsonStr) {
        StringBuilder sb = new StringBuilder();
        if (!uri.startsWith(URL_DELIMITER)) {
            uri = URL_DELIMITER + uri;
        }
        if (uri.endsWith(URL_DELIMITER)) {
            uri = uri.substring(0, uri.length() - 1);
        }
        sb.append(uri).append(LINE_DELIMITER);
        sb.append(httpMethod).append(LINE_DELIMITER);
        if (queryParams == null || queryParams.isEmpty()) {
            sb.append(LINE_DELIMITER);
        } else {
            ArrayList<String> keys = new ArrayList<String>(queryParams.keySet());
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                if (i != 0) {
                    sb.append("&");
                }
                sb.append(GwSigns.urlEncode(key));
                sb.append("=");
                sb.append(GwSigns.urlEncode(queryParams.get(key)));
            }
            sb.append(LINE_DELIMITER);
        }
        if (rawPostJsonStr == null) {
            rawPostJsonStr = DEFAULT_STRING;
        }
        sb.append(rawPostJsonStr).append(LINE_DELIMITER);
        TreeMap<String, String> sortedSignHeaders = new TreeMap<String, String>(signHeaders);
        for (Map.Entry<String, String> entry : sortedSignHeaders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) continue;
            sb.append(key.toLowerCase());
            sb.append(HEADER_DELIMITER);
            sb.append(value);
            sb.append(LINE_DELIMITER);
        }
        String stringToSign = sb.toString();
        stringToSign = stringToSign.substring(0, stringToSign.length() - LINE_DELIMITER.length());
        return stringToSign;
    }
}

