/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.filter;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaTokenContextModelBox;
import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.reactor.context.SaReactorSyncHolder;
import cn.dev33.satoken.reactor.util.SaReactorOperateUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-103)
public class SaTokenCorsFilterForReactor
implements WebFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        try {
            SaReactorSyncHolder.setContext(exchange);
            SaTokenContextModelBox box = SaHolder.getContext().getModelBox();
            SaStrategy.instance.corsHandle.execute(box.getRequest(), box.getResponse(), box.getStorage());
        }
        catch (StopMatchException box) {
        }
        catch (BackResultException e) {
            Mono<Void> mono = SaReactorOperateUtil.writeResult(exchange, e.getMessage());
            return mono;
        }
        finally {
            SaReactorSyncHolder.clearContext();
        }
        return chain.filter(exchange);
    }
}

