/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.cache.selector;

import cn.idev.excel.cache.Ehcache;
import cn.idev.excel.cache.MapCache;
import cn.idev.excel.cache.ReadCache;
import cn.idev.excel.cache.selector.ReadCacheSelector;
import java.io.IOException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReadCacheSelector
implements ReadCacheSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleReadCacheSelector.class);
    private static final long B2M = 1000000L;
    private static final long DEFAULT_MAX_USE_MAP_CACHE_SIZE = 5L;
    private static final int DEFAULT_MAX_EHCACHE_ACTIVATE_BATCH_COUNT = 20;
    private Long maxUseMapCacheSize;
    @Deprecated
    private Integer maxCacheActivateSize;
    private Integer maxCacheActivateBatchCount;

    public SimpleReadCacheSelector() {
    }

    @Deprecated
    public SimpleReadCacheSelector(Long maxUseMapCacheSize, Integer maxCacheActivateSize) {
        this.maxUseMapCacheSize = maxUseMapCacheSize;
        this.maxCacheActivateSize = maxCacheActivateSize;
    }

    @Override
    public ReadCache readCache(PackagePart sharedStringsTablePackagePart) {
        long size = sharedStringsTablePackagePart.getSize();
        if (size < 0L) {
            try {
                size = sharedStringsTablePackagePart.getInputStream().available();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get file size, default used MapCache");
                return new MapCache();
            }
        }
        if (this.maxUseMapCacheSize == null) {
            this.maxUseMapCacheSize = 5L;
        }
        if (size < this.maxUseMapCacheSize * 1000000L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Use map cache.size:{}", (Object)size);
            }
            return new MapCache();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Use ehcache.size:{}", (Object)size);
        }
        if (this.maxCacheActivateSize != null) {
            return new Ehcache(this.maxCacheActivateSize, this.maxCacheActivateBatchCount);
        }
        if (this.maxCacheActivateBatchCount == null) {
            this.maxCacheActivateBatchCount = 20;
        }
        return new Ehcache(this.maxCacheActivateSize, this.maxCacheActivateBatchCount);
    }

    public Long getMaxUseMapCacheSize() {
        return this.maxUseMapCacheSize;
    }

    @Deprecated
    public Integer getMaxCacheActivateSize() {
        return this.maxCacheActivateSize;
    }

    public Integer getMaxCacheActivateBatchCount() {
        return this.maxCacheActivateBatchCount;
    }

    public void setMaxUseMapCacheSize(Long maxUseMapCacheSize) {
        this.maxUseMapCacheSize = maxUseMapCacheSize;
    }

    @Deprecated
    public void setMaxCacheActivateSize(Integer maxCacheActivateSize) {
        this.maxCacheActivateSize = maxCacheActivateSize;
    }

    public void setMaxCacheActivateBatchCount(Integer maxCacheActivateBatchCount) {
        this.maxCacheActivateBatchCount = maxCacheActivateBatchCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleReadCacheSelector)) {
            return false;
        }
        SimpleReadCacheSelector other = (SimpleReadCacheSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$maxUseMapCacheSize = this.getMaxUseMapCacheSize();
        Long other$maxUseMapCacheSize = other.getMaxUseMapCacheSize();
        if (this$maxUseMapCacheSize == null ? other$maxUseMapCacheSize != null : !((Object)this$maxUseMapCacheSize).equals(other$maxUseMapCacheSize)) {
            return false;
        }
        Integer this$maxCacheActivateSize = this.getMaxCacheActivateSize();
        Integer other$maxCacheActivateSize = other.getMaxCacheActivateSize();
        if (this$maxCacheActivateSize == null ? other$maxCacheActivateSize != null : !((Object)this$maxCacheActivateSize).equals(other$maxCacheActivateSize)) {
            return false;
        }
        Integer this$maxCacheActivateBatchCount = this.getMaxCacheActivateBatchCount();
        Integer other$maxCacheActivateBatchCount = other.getMaxCacheActivateBatchCount();
        return !(this$maxCacheActivateBatchCount == null ? other$maxCacheActivateBatchCount != null : !((Object)this$maxCacheActivateBatchCount).equals(other$maxCacheActivateBatchCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleReadCacheSelector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxUseMapCacheSize = this.getMaxUseMapCacheSize();
        result = result * 59 + ($maxUseMapCacheSize == null ? 43 : ((Object)$maxUseMapCacheSize).hashCode());
        Integer $maxCacheActivateSize = this.getMaxCacheActivateSize();
        result = result * 59 + ($maxCacheActivateSize == null ? 43 : ((Object)$maxCacheActivateSize).hashCode());
        Integer $maxCacheActivateBatchCount = this.getMaxCacheActivateBatchCount();
        result = result * 59 + ($maxCacheActivateBatchCount == null ? 43 : ((Object)$maxCacheActivateBatchCount).hashCode());
        return result;
    }
}

