/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NettyClientInitializer;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.StringUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient
implements IHttpClient {
    private static Logger LOG = LoggerFactory.getLogger(NettyHttpClient.class);
    private String _authCode;
    private int _maxRetryTimes;
    private int _readTimeout;
    private Channel _channel;
    private Bootstrap b;
    private EventLoopGroup _workerGroup;
    private SslContext _sslCtx;
    private final String _encryptType;

    public NettyHttpClient(String authCode, HttpProxy proxy, ClientConfig config) {
        this._maxRetryTimes = config.getMaxRetryTimes();
        this._readTimeout = config.getReadTimeout();
        String message = MessageFormat.format("Created instance with connectionTimeout {0}, readTimeout {1}, maxRetryTimes {2}, SSL Version {3}", config.getConnectionTimeout(), this._readTimeout, this._maxRetryTimes, config.getSSLVersion());
        LOG.debug(message);
        this._authCode = authCode;
        this._encryptType = config.getEncryptType();
        try {
            this._sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            this._workerGroup = new NioEventLoopGroup();
            this.b = new Bootstrap();
            this.b.group(this._workerGroup);
            this.b.channel(NioSocketChannel.class);
            this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        catch (SSLException e) {
            e.printStackTrace();
        }
    }

    public void sendRequest(HttpMethod method, String content, URI uri, BaseCallback callback) {
        DefaultFullHttpRequest request;
        this.b = new Bootstrap();
        if (this.b.group() == null) {
            this.b.group(this._workerGroup);
        }
        this.b.channel(NioSocketChannel.class);
        this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.handler((ChannelHandler)new NettyClientInitializer(this._sslCtx, callback, null));
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        this._channel = this.b.connect(uri.getHost(), port).syncUninterruptibly().channel();
        if (null != content) {
            ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8));
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath(), byteBuf);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
        } else {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
        }
        if (!StringUtils.isEmpty(this._encryptType)) {
            request.headers().set("X-Encrypt-Type", (Object)this._encryptType);
        }
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
        request.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this._authCode);
        request.headers().set("Content-Type", (Object)"application/json;charset=utf-8");
        LOG.info("Sending request. " + request);
        LOG.info("Send body: " + content);
        this._channel.writeAndFlush((Object)request);
        try {
            this._channel.closeFuture().sync();
            this._workerGroup.shutdownGracefully();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResponseWrapper sendGet(String url) throws APIConnectionException, APIRequestException {
        return this.sendGet(url, null);
    }

    @Override
    public ResponseWrapper sendGet(String url, String content) throws APIConnectionException, APIRequestException {
        return this.sendHttpRequest(HttpMethod.GET, url, content);
    }

    @Override
    public ResponseWrapper sendPut(String url, String content) throws APIConnectionException, APIRequestException {
        return this.sendHttpRequest(HttpMethod.PUT, url, content);
    }

    @Override
    public ResponseWrapper sendPost(String url, String content) throws APIConnectionException, APIRequestException {
        return this.sendHttpRequest(HttpMethod.POST, url, content);
    }

    @Override
    public ResponseWrapper sendDelete(String url) throws APIConnectionException, APIRequestException {
        return this.sendDelete(url, null);
    }

    @Override
    public ResponseWrapper sendDelete(String url, String content) throws APIConnectionException, APIRequestException {
        return this.sendHttpRequest(HttpMethod.DELETE, url, content);
    }

    private ResponseWrapper sendHttpRequest(HttpMethod method, String url, String body) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper;
        block22: {
            CountDownLatch latch = new CountDownLatch(1);
            NettyClientInitializer initializer = new NettyClientInitializer(this._sslCtx, null, latch);
            this.b.handler((ChannelHandler)initializer);
            wrapper = new ResponseWrapper();
            URI uri = null;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e1) {
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e1);
                throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e1, true);
            }
            String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
            String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            int port = uri.getPort();
            if (port == -1) {
                if ("http".equalsIgnoreCase(scheme)) {
                    port = 80;
                } else if ("https".equalsIgnoreCase(scheme)) {
                    port = 443;
                }
            }
            try {
                DefaultFullHttpRequest request;
                ChannelFuture connect = this.b.connect(host, port);
                this._channel = connect.sync().channel();
                if (null != body) {
                    ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])body.getBytes(CharsetUtil.UTF_8));
                    request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath(), byteBuf);
                    request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
                } else {
                    request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
                }
                if (!StringUtils.isEmpty(this._encryptType)) {
                    request.headers().set("X-Encrypt-Type", (Object)this._encryptType);
                }
                request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
                request.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this._authCode);
                request.headers().set("Content-Type", (Object)"application/json;charset=utf-8");
                connect.awaitUninterruptibly();
                LOG.info("Sending request. " + request);
                LOG.info("Send body: " + body);
                this._channel.writeAndFlush((Object)request);
                latch.await();
                wrapper = initializer.getResponse();
                int status = wrapper.responseCode;
                String responseContent = wrapper.responseContent;
                if (status >= 200 && status < 300) {
                    LOG.debug("Succeed to get response OK - responseCode:" + status);
                    LOG.debug("Response Content - " + responseContent);
                    break block22;
                }
                if (status >= 300 && status < 400) {
                    LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + responseContent);
                    break block22;
                }
                LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + responseContent);
                switch (status) {
                    case 400: {
                        LOG.warn("Your request params is invalid. Please check them according to error message.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 401: {
                        LOG.warn("Authentication failed! Please check authentication params according to docs.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 403: {
                        LOG.warn("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 404: {
                        LOG.warn("Request page is not found! Maybe your params is invalid.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 410: {
                        LOG.warn("Request resource is no longer in service. Please according to notice on official website.");
                        wrapper.setErrorObject();
                    }
                    case 429: {
                        LOG.warn("Too many requests! Please review your appkey's request quota.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 500: 
                    case 502: 
                    case 503: 
                    case 504: {
                        LOG.warn("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                        break;
                    }
                    default: {
                        LOG.warn("Unexpected response.");
                    }
                }
                throw new APIRequestException(wrapper);
            }
            catch (InterruptedException e) {
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
            }
        }
        return wrapper;
    }

    public void send(ByteBuf body, HttpMethod method, URI uri) {
        DefaultFullHttpRequest request;
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        this._channel = this.b.connect(host, port).syncUninterruptibly().channel();
        if (null != body) {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath(), body);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
        } else {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
        }
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
        request.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this._authCode);
        request.headers().set("Content-Type", (Object)"application/json;charset=utf-8");
        LOG.info("Sending request. " + request);
        LOG.info("Send body: " + body);
        this._channel.writeAndFlush((Object)request);
    }

    public void close() {
        if (null != this._channel) {
            this._channel.closeFuture().syncUninterruptibly();
            this._workerGroup.shutdownGracefully();
            this._channel = null;
            this._workerGroup = null;
        }
        System.out.println("Finished request(s)");
    }

    public static interface BaseCallback {
        public void onSucceed(ResponseWrapper var1);
    }
}

