/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.lock.impl;

import cn.stylefeng.roses.core.lock.DistributedLock;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private static StringRedisTemplate redisTemplate;
    private String lockKey;
    private int expireMilliseconds = 15000;
    private int timeoutMilliseconds = 15000;
    private boolean locked = false;

    public RedisLock(String lockKey) {
        this.lockKey = lockKey;
    }

    public RedisLock(String lockKey, int timeoutMilliseconds) {
        this.lockKey = lockKey;
        this.timeoutMilliseconds = timeoutMilliseconds;
    }

    public RedisLock(String lockKey, int expireMilliseconds, int timeoutMilliseconds) {
        this.lockKey = lockKey;
        this.expireMilliseconds = expireMilliseconds;
        this.timeoutMilliseconds = timeoutMilliseconds;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    @Override
    public synchronized boolean acquire() {
        int timeout = this.timeoutMilliseconds;
        if (redisTemplate == null) {
            redisTemplate = SpringContextHolder.getBean(StringRedisTemplate.class);
        }
        try {
            while (timeout >= 0) {
                String oldValueStr;
                long expires = System.currentTimeMillis() + (long)this.expireMilliseconds + 1L;
                String expiresStr = String.valueOf(expires);
                if (redisTemplate.opsForValue().setIfAbsent((Object)this.lockKey, (Object)expiresStr).booleanValue()) {
                    this.locked = true;
                    log.info("[1] \u6210\u529f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501!");
                    return true;
                }
                String redisValueTime = (String)redisTemplate.opsForValue().get((Object)this.lockKey);
                if (redisValueTime != null && Long.parseLong(redisValueTime) < System.currentTimeMillis() && (oldValueStr = (String)redisTemplate.opsForValue().getAndSet((Object)this.lockKey, (Object)expiresStr)) != null && oldValueStr.equals(redisValueTime)) {
                    this.locked = true;
                    log.info("[2] \u6210\u529f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501!");
                    return true;
                }
                timeout -= 100;
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9501\u51fa\u73b0\u5f02\u5e38, \u5fc5\u987b\u91ca\u653e: {}", (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public synchronized void release() {
        if (redisTemplate == null) {
            redisTemplate = SpringContextHolder.getBean(StringRedisTemplate.class);
        }
        try {
            String redisValueTime;
            if (this.locked && (redisValueTime = (String)redisTemplate.opsForValue().get((Object)this.lockKey)) != null && Long.parseLong(redisValueTime) > System.currentTimeMillis()) {
                redisTemplate.delete((Object)this.lockKey);
                this.locked = false;
                log.info("[3] \u6210\u529f\u91ca\u653e\u5206\u5e03\u5f0f\u9501!");
            }
        }
        catch (Exception e) {
            log.error("\u91ca\u653e\u9501\u51fa\u73b0\u5f02\u5e38, \u5fc5\u987b\u91ca\u653e: {}", (Object)e.getMessage());
        }
    }
}

