/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.sms.modular.aliyun;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.sms.SmsSender;
import cn.stylefeng.roses.sms.modular.aliyun.enums.AliyunSmsResultEnum;
import cn.stylefeng.roses.sms.modular.aliyun.exp.AliyunSmsException;
import cn.stylefeng.roses.sms.modular.aliyun.msign.MultiSignManager;
import cn.stylefeng.roses.sms.modular.aliyun.prop.AliyunSmsProperties;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSmsSender
implements SmsSender {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsSender.class);
    private final MultiSignManager multiSignManager;
    private final AliyunSmsProperties aliyunSmsProperties;

    public AliyunSmsSender(MultiSignManager multiSignManager, AliyunSmsProperties aliyunSmsProperties) {
        this.multiSignManager = multiSignManager;
        this.aliyunSmsProperties = aliyunSmsProperties;
    }

    @Override
    public void sendSms(String phone, String templateCode, Map<String, Object> params) {
        log.info("\u5f00\u59cb\u53d1\u9001\u963f\u91cc\u4e91\u77ed\u4fe1\uff0c\u624b\u673a\u53f7\u662f\uff1a" + phone + ",\u6a21\u677f\u53f7\u662f\uff1a" + templateCode + ",\u53c2\u6570\u662f\uff1a" + params);
        this.assertSendSmsParams(phone, templateCode, params, this.aliyunSmsProperties);
        IAcsClient iAcsClient = this.initClient();
        JSONObject smsRes = this.createSmsRequest(phone, templateCode, params, iAcsClient);
        if (!AliyunSmsResultEnum.OK.getCode().equals(smsRes.getString("Code"))) {
            String code = AliyunSmsResultEnum.SYSTEM_ERROR.getCode();
            String errorMessage = AliyunSmsResultEnum.SYSTEM_ERROR.getMessage();
            for (AliyunSmsResultEnum smsExceptionEnum : AliyunSmsResultEnum.values()) {
                if (!smsExceptionEnum.getCode().equals(smsRes.getString("Code"))) continue;
                code = smsExceptionEnum.getCode();
                errorMessage = smsExceptionEnum.getMessage();
            }
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff01code = " + code + ",message = " + errorMessage);
            throw new AliyunSmsException(code, errorMessage);
        }
    }

    private IAcsClient initClient() {
        String accessKeyId = this.aliyunSmsProperties.getAccessKeyId();
        String accessKeySecret = this.aliyunSmsProperties.getAccessKeySecret();
        DefaultProfile profile = DefaultProfile.getProfile((String)this.aliyunSmsProperties.getRegionId(), (String)accessKeyId, (String)accessKeySecret);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    private JSONObject createSmsRequest(String phoneNumber, String templateCode, Map<String, Object> params, IAcsClient acsClient) {
        CommonRequest request = new CommonRequest();
        request.setSysDomain(this.aliyunSmsProperties.getSmsDomain());
        request.setSysVersion(this.aliyunSmsProperties.getSmsVersion());
        request.setSysAction(this.aliyunSmsProperties.getSmsSendAction());
        request.putQueryParameter("PhoneNumbers", phoneNumber);
        request.putQueryParameter("SignName", this.getSmsSign(phoneNumber));
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParam", JSON.toJSONString(params));
        try {
            CommonResponse commonResponse = acsClient.getCommonResponse(request);
            String data = commonResponse.getData();
            String jsonResult = data.replaceAll("''", "");
            log.info("\u83b7\u53d6\u5230\u53d1\u9001\u77ed\u4fe1\u7684\u54cd\u5e94\u7ed3\u679c\uff01{}", (Object)jsonResult);
            return JSON.parseObject((String)jsonResult);
        }
        catch (ClientException e) {
            log.error("\u521d\u59cb\u5316\u963f\u91cc\u4e91sms\u5f02\u5e38\uff01\u53ef\u80fd\u662faccessKey\u548csecret\u9519\u8bef\uff01", (Throwable)e);
            throw new AliyunSmsException(AliyunSmsResultEnum.INIT_SMS_CLIENT_ERROR.getCode(), AliyunSmsResultEnum.INIT_SMS_CLIENT_ERROR.getMessage());
        }
    }

    private void assertSendSmsParams(String phoneNumber, String templateCode, Map<String, Object> params, AliyunSmsProperties aliyunSmsProperties) {
        if (ObjectUtil.hasEmpty((Object[])new Object[]{phoneNumber, templateCode, params, aliyunSmsProperties})) {
            log.error("\u963f\u91cc\u4e91\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff01\u8bf7\u6c42\u53c2\u6570\u5b58\u5728\u7a7a\uff01");
            throw new AliyunSmsException(AliyunSmsResultEnum.PARAM_NULL.getCode(), AliyunSmsResultEnum.PARAM_NULL.getMessage());
        }
    }

    private String getSmsSign(String phone) {
        String signName = this.aliyunSmsProperties.getSignName();
        if (!signName.contains(",")) {
            log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u7b7e\u540d\u4e3a\uff1a" + signName + ",\u7535\u8bdd\u4e3a\uff1a" + phone);
            return signName;
        }
        return this.multiSignManager.getSign(phone, signName);
    }
}

