/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import cn.hutool.core.util.ServiceLoaderUtil;
import com.aizuda.snailjob.client.common.SnailJobLogThreadLocal;
import com.aizuda.snailjob.client.common.SnailThreadLocal;
import com.aizuda.snailjob.client.common.threadlocal.CommonThreadLocal;
import com.aizuda.snailjob.common.core.model.JobContext;
import java.util.Objects;

public final class JobContextManager {
    private static final SnailThreadLocal<JobContext> JOB_CONTEXT_LOCAL = JobContextManager.initThreadLocal();

    private JobContextManager() {
    }

    private static SnailThreadLocal<JobContext> initThreadLocal() {
        SnailThreadLocal snailThreadLocal = (SnailThreadLocal)ServiceLoaderUtil.loadFirst(SnailJobLogThreadLocal.class);
        if (Objects.isNull(snailThreadLocal)) {
            snailThreadLocal = new CommonThreadLocal(new ThreadLocal());
        }
        return snailThreadLocal;
    }

    public static void setJobContext(JobContext jobContext) {
        JOB_CONTEXT_LOCAL.set((Object)jobContext);
    }

    public static JobContext getJobContext() {
        return (JobContext)JOB_CONTEXT_LOCAL.get();
    }

    public static void removeJobContext() {
        JOB_CONTEXT_LOCAL.remove();
    }
}

