/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.handler.query;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.job.core.dto.WorkflowDetailResponseVO;
import com.aizuda.snailjob.client.job.core.handler.AbstractJobRequestHandler;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import java.util.Objects;

public class RequestQueryWorkflowBatchHandler
extends AbstractJobRequestHandler<WorkflowDetailResponseVO> {
    private final Long workflowBatchId;

    public RequestQueryWorkflowBatchHandler(Long workflowBatchId) {
        this.workflowBatchId = workflowBatchId;
    }

    protected void afterExecute(WorkflowDetailResponseVO workflowDetailResponseVO) {
    }

    protected void beforeExecute() {
    }

    protected WorkflowDetailResponseVO doExecute() {
        Result<Object> result = this.client.getWorkflowBatchDetail(this.workflowBatchId);
        Assert.isTrue((StatusEnum.YES.getStatus().intValue() == result.getStatus() ? 1 : 0) != 0, () -> new SnailJobClientException(result.getMessage()));
        Object data = result.getData();
        Assert.isTrue((boolean)Objects.nonNull(data), () -> new SnailJobClientException("Failed to get workflow task batch details for [{}]", (Object)this.workflowBatchId));
        return (WorkflowDetailResponseVO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)data), WorkflowDetailResponseVO.class);
    }

    protected Pair<Boolean, String> checkRequest() {
        return Pair.of((Object)(this.workflowBatchId != null && !Long.valueOf(0L).equals(this.workflowBatchId) ? 1 : 0), (Object)"queryJobBatchId cannot be null and must be greater than 0");
    }
}

