/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.register;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.job.core.Scanner;
import com.aizuda.snailjob.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.snailjob.client.job.core.dto.JobExecutorInfo;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class JobExecutorRegistrar
implements Lifecycle {
    private final List<Scanner> scanners;

    public void registerRetryHandler(JobExecutorInfo jobExecutorInfo) {
        if (JobExecutorInfoCache.isExisted(jobExecutorInfo.getExecutorName())) {
            throw new SnailJobClientException("Duplicate executor names are not allowed: {}", (Object)jobExecutorInfo.getExecutorName());
        }
        JobExecutorInfoCache.put(jobExecutorInfo);
    }

    public void registerRetryHandler(List<JobExecutorInfo> contextList) {
        for (JobExecutorInfo jobExecutorInfo : contextList) {
            this.registerRetryHandler(jobExecutorInfo);
        }
    }

    public void start() {
        for (Scanner scanner : this.scanners) {
            this.registerRetryHandler(scanner.doScan());
        }
    }

    public void close() {
    }

    @Generated
    public JobExecutorRegistrar(List<Scanner> scanners) {
        this.scanners = scanners;
    }
}

