/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.allocate.server;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.ServerLoadBalance;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class AllocateMessageQueueAveragely
implements ServerLoadBalance<Integer, String> {
    @Override
    public List<Integer> allocate(String currentCID, List<Integer> bucketList, List<String> serverList) {
        if (CollUtil.isEmpty(serverList)) {
            return Lists.newArrayList();
        }
        ArrayList<Integer> consumerBucket = new ArrayList<Integer>();
        int index = serverList.indexOf(currentCID);
        if (index < 0) {
            SnailJobLog.LOCAL.warn("currentCID: [{}] not in serverList:[{}]", new Object[]{currentCID, serverList});
            return Lists.newArrayList();
        }
        int mod = bucketList.size() % serverList.size();
        int averageSize = bucketList.size() <= serverList.size() ? 1 : (mod > 0 && index < mod ? bucketList.size() / serverList.size() + 1 : bucketList.size() / serverList.size());
        int startIndex = mod > 0 && index < mod ? index * averageSize : index * averageSize + mod;
        int range = Math.min(averageSize, bucketList.size() - startIndex);
        for (int i = 0; i < range; ++i) {
            consumerBucket.add(bucketList.get((startIndex + i) % bucketList.size()));
        }
        return consumerBucket;
    }

    @Override
    public String getName() {
        return "AVG";
    }
}

