/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.convert.JobConverter;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.HttpHeaderUtil;
import com.aizuda.snailjob.server.common.vo.JobRequestVO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiAddJobRequestHandler
extends PostHttpRequestHandler {
    private final SystemProperties systemProperties;
    private final JobMapper jobMapper;

    public boolean supports(String path) {
        return "/api/job/add".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Add job content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        JobRequestVO jobRequestVO = (JobRequestVO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), JobRequestVO.class);
        if (StrUtil.isBlank((CharSequence)jobRequestVO.getGroupName())) {
            jobRequestVO.setGroupName(HttpHeaderUtil.getGroupName((HttpHeaders)headers));
        }
        Job job = JobConverter.INSTANCE.convert(jobRequestVO);
        job.setResident(this.isResident(jobRequestVO));
        job.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(jobRequestVO.getGroupName() + jobRequestVO.getJobName())) % this.systemProperties.getBucketTotal()));
        job.setNextTriggerAt(OpenApiAddJobRequestHandler.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        job.setNamespaceId(HttpHeaderUtil.getNamespace((HttpHeaders)headers));
        job.setId(null);
        Assert.isTrue((1 == this.jobMapper.insert((Object)job) ? 1 : 0) != 0, () -> new SnailJobServerException("Adding new task failed"));
        return new SnailJobRpcResult((Object)job.getId(), retryRequest.getReqId());
    }

    private Integer isResident(JobRequestVO jobRequestVO) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return StatusEnum.NO.getStatus();
        }
        if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.FIXED.getType()) {
            if (Integer.parseInt(jobRequestVO.getTriggerInterval()) < 10) {
                return StatusEnum.YES.getStatus();
            }
        } else if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType()) {
            if (CronUtils.getExecuteInterval((String)jobRequestVO.getTriggerInterval()) < 10000L) {
                return StatusEnum.YES.getStatus();
            }
        } else {
            throw new SnailJobServerException("Unknown trigger type");
        }
        return StatusEnum.NO.getStatus();
    }

    private static Long calculateNextTriggerAt(JobRequestVO jobRequestVO, Long time) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)jobRequestVO.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(jobRequestVO.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    @Generated
    public OpenApiAddJobRequestHandler(SystemProperties systemProperties, JobMapper jobMapper) {
        this.systemProperties = systemProperties;
        this.jobMapper = jobMapper;
    }
}

