/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.JobTriggerDTO;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.WorkflowPrePareHandler;
import com.aizuda.snailjob.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiTriggerWorkFlowRequestHandler
extends PostHttpRequestHandler {
    private final WorkflowMapper workflowMapper;
    private final AccessTemplate accessTemplate;
    private final WorkflowPrePareHandler terminalWorkflowPrepareHandler;

    public boolean supports(String path) {
        return "/api/job/triggerWorkFlow".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        HashSet<String> namesSet;
        SnailJobLog.LOCAL.debug("Trigger job content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        JobTriggerDTO workflowDTO = (JobTriggerDTO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), JobTriggerDTO.class);
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowDTO.getJobId());
        Assert.notNull((Object)workflow, () -> new SnailJobServerException("workflow can not be null."));
        if (StrUtil.isNotBlank((CharSequence)workflow.getGroupName()) && CollectionUtil.isNotEmpty(namesSet = new HashSet<String>(Arrays.asList(workflow.getGroupName().split(", "))))) {
            for (String groupName : namesSet) {
                long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)groupName)).eq(GroupConfig::getNamespaceId, (Object)workflow.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
                if (count > 0L) continue;
                SnailJobLog.LOCAL.warn("Group [{}] is closed, manual execution is not supported.", new Object[]{workflow.getGroupName()});
                return new SnailJobRpcResult((Object)false, retryRequest.getReqId());
            }
        }
        WorkflowTaskPrepareDTO prepareDTO = WorkflowTaskConverter.INSTANCE.toWorkflowTaskPrepareDTO(workflow);
        prepareDTO.setNextTriggerAt(DateUtils.toNowMilli());
        prepareDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType());
        String tmpWfContext = workflowDTO.getTmpArgsStr();
        if (StrUtil.isNotBlank((CharSequence)tmpWfContext) && !JsonUtil.isEmptyJson((String)tmpWfContext)) {
            prepareDTO.setWfContext(tmpWfContext);
        }
        this.terminalWorkflowPrepareHandler.handler(prepareDTO);
        return new SnailJobRpcResult((Object)true, retryRequest.getReqId());
    }

    @Generated
    public OpenApiTriggerWorkFlowRequestHandler(WorkflowMapper workflowMapper, AccessTemplate accessTemplate, WorkflowPrePareHandler terminalWorkflowPrepareHandler) {
        this.workflowMapper = workflowMapper;
        this.accessTemplate = accessTemplate;
        this.terminalWorkflowPrepareHandler = terminalWorkflowPrepareHandler;
    }
}

