/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.stop;

import com.aizuda.snailjob.client.model.StopJobDTO;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.job.task.client.JobRpcClient;
import com.aizuda.snailjob.server.job.task.dto.RealStopTaskInstanceDTO;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JobRealStopTaskInstanceActor")
@Scope(value="prototype")
public class RealStopTaskActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RealStopTaskActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RealStopTaskInstanceDTO.class, realStopTaskInstanceDTO -> {
            try {
                this.doStop((RealStopTaskInstanceDTO)realStopTaskInstanceDTO);
            }
            catch (Exception e) {
                log.error("Stopping task execution failed. [{}]", (Object)JsonUtil.toJsonString((Object)realStopTaskInstanceDTO), (Object)e);
            }
        }).build();
    }

    private void doStop(RealStopTaskInstanceDTO realStopTaskInstanceDTO) {
        RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode((String)realStopTaskInstanceDTO.getGroupName(), (String)realStopTaskInstanceDTO.getNamespaceId(), (String)realStopTaskInstanceDTO.getClientId());
        if (Objects.nonNull(registerNodeInfo)) {
            this.requestClient(realStopTaskInstanceDTO, registerNodeInfo);
        }
    }

    private Result<Boolean> requestClient(RealStopTaskInstanceDTO realStopTaskInstanceDTO, RegisterNodeInfo registerNodeInfo) {
        JobRpcClient rpcClient = (JobRpcClient)RequestBuilder.newBuilder().nodeInfo(registerNodeInfo).failRetry(Boolean.TRUE.booleanValue()).retryTimes(3).retryInterval(1).client(JobRpcClient.class).build();
        StopJobDTO stopJobDTO = new StopJobDTO();
        stopJobDTO.setTaskBatchId(realStopTaskInstanceDTO.getTaskBatchId());
        stopJobDTO.setJobId(realStopTaskInstanceDTO.getJobId());
        stopJobDTO.setGroupName(realStopTaskInstanceDTO.getGroupName());
        return rpcClient.stop(stopJobDTO);
    }
}

