/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.retry.task.support.idempotent.IdempotentHolder;
import com.aizuda.snailjob.server.retry.task.support.idempotent.TimerIdempotent;
import io.netty.util.HashedWheelTimer;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class RetryTimerWheel {
    private static final int TICK_DURATION = 500;
    private static final String THREAD_NAME_PREFIX = "retry-task-timer-wheel-";
    private static HashedWheelTimer timer = null;
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(16, 16, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("retry-task-timer-wheel-"));
    private static final TimerIdempotent idempotent = IdempotentHolder.getTimerIdempotent();

    public static synchronized void registerWithRetry(Supplier<TimerTask<String>> task, Duration delay) {
        TimerTask<String> timerTask = task.get();
        RetryTimerWheel.register((String)timerTask.idempotentKey(), timerTask, delay);
    }

    public static synchronized void register(String idempotentKey, TimerTask<String> task, Duration delay) {
        RetryTimerWheel.register(idempotentKey, hashedWheelTimer -> {
            SnailJobLog.LOCAL.debug("Join time wheel. Delay:[{}ms] Task type:[{}]", new Object[]{delay.toMillis(), idempotentKey});
            timer.newTimeout((io.netty.util.TimerTask)task, Math.max(delay.toMillis(), 0L), TimeUnit.MILLISECONDS);
        });
    }

    public static synchronized void register(String idempotentKey, Consumer<HashedWheelTimer> consumer) {
        if (!RetryTimerWheel.isExisted(idempotentKey)) {
            try {
                consumer.accept(timer);
                idempotent.set(idempotentKey);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Failed to join time wheel. uniqueId:[{}]", new Object[]{idempotentKey, e});
            }
        }
    }

    public static boolean isExisted(String idempotentKey) {
        return idempotent.isExist(idempotentKey);
    }

    public static void clearCache(String idempotentKey) {
        idempotent.clear(idempotentKey);
    }

    @Generated
    private RetryTimerWheel() {
    }

    static {
        timer = new HashedWheelTimer((ThreadFactory)new CustomizableThreadFactory(THREAD_NAME_PREFIX), 500L, TimeUnit.MILLISECONDS, 512, true, -1L, (Executor)executor);
        timer.start();
    }
}

