/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.datasource.config;

import com.alibaba.cloud.sentinel.datasource.config.AbstractDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.factorybean.RedisDataSourceFactoryBean;
import java.time.Duration;
import java.util.List;
import org.springframework.util.StringUtils;

public class RedisDataSourceProperties
extends AbstractDataSourceProperties {
    private String host = "localhost";
    private int port = 6379;
    private String password;
    private int database;
    private Duration timeout;
    private List<String> nodes;
    private String ruleKey;
    private String channel;
    private String masterId;

    public RedisDataSourceProperties() {
        super(RedisDataSourceFactoryBean.class.getName());
    }

    @Override
    public void preCheck(String dataSourceName) {
        super.preCheck(dataSourceName);
        if (StringUtils.isEmpty((Object)this.ruleKey)) {
            throw new IllegalArgumentException("RedisDataSource  ruleKey can not be empty");
        }
        if (StringUtils.isEmpty((Object)this.channel)) {
            throw new IllegalArgumentException("RedisDataSource  channel can not be empty");
        }
        if (!StringUtils.isEmpty((Object)this.masterId) && StringUtils.isEmpty((Object)this.masterId)) {
            throw new IllegalArgumentException("RedisDataSource  sentinel model\uff0cmasterId can not be empty");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<String> nodes) {
        this.nodes = nodes;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }
}

