/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http;

import com.alibaba.druid.stat.DruidStatService;
import com.alibaba.druid.support.http.util.IPAddress;
import com.alibaba.druid.support.http.util.IPRange;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.IOUtils;
import com.alibaba.druid.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class StatViewServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(StatViewServlet.class);
    private static final long serialVersionUID = 1L;
    public static final String PARAM_NAME_RESET_ENABLE = "resetEnable";
    public static final String PARAM_NAME_ALLOW = "allow";
    public static final String PARAM_NAME_DENY = "deny";
    public static final String PARAM_NAME_USERNAME = "loginUsername";
    public static final String PARAM_NAME_PASSWORD = "loginPassword";
    public static final String SESSION_USER_KEY = "druid-user";
    private static final String RESOURCE_PATH = "support/http/resources";
    private static final String TEMPLATE_PAGE_RESOURCE_PATH = "support/http/resources/template.html";
    private DruidStatService statService = DruidStatService.getInstance();
    public String templatePage;
    private List<IPRange> allowList = new ArrayList<IPRange>();
    private List<IPRange> denyList = new ArrayList<IPRange>();
    private String username = null;
    private String password = null;

    public void init() throws ServletException {
        IPRange ipRange;
        String param;
        this.initAuthEnv();
        try {
            this.templatePage = IOUtils.readFromResource(TEMPLATE_PAGE_RESOURCE_PATH);
        }
        catch (IOException e) {
            throw new ServletException("error read templatePage:support/http/resources/template.html", (Throwable)e);
        }
        try {
            param = this.getInitParameter(PARAM_NAME_RESET_ENABLE);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                boolean resetEnable = Boolean.parseBoolean(param);
                this.statService.setResetEnable(resetEnable);
            }
        }
        catch (Exception e) {
            String msg = "initParameter config error, resetEnable : " + this.getInitParameter(PARAM_NAME_RESET_ENABLE);
            LOG.error(msg, e);
        }
        try {
            param = this.getInitParameter(PARAM_NAME_ALLOW);
            if (param != null && param.trim().length() != 0) {
                String[] items;
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.allowList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            String msg = "initParameter config error, allow : " + this.getInitParameter(PARAM_NAME_ALLOW);
            LOG.error(msg, e);
        }
        try {
            param = this.getInitParameter(PARAM_NAME_DENY);
            if (param != null && param.trim().length() != 0) {
                String[] items;
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.denyList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            String msg = "initParameter config error, deny : " + this.getInitParameter(PARAM_NAME_DENY);
            LOG.error(msg, e);
        }
    }

    private void initAuthEnv() {
        String paramPassword;
        String paramUserName = this.getInitParameter(PARAM_NAME_USERNAME);
        if (!StringUtils.isEmpty(paramUserName)) {
            this.username = paramUserName;
        }
        if (!StringUtils.isEmpty(paramPassword = this.getInitParameter(PARAM_NAME_PASSWORD))) {
            this.password = paramPassword;
        }
    }

    public boolean isRequireAuth() {
        return this.username != null;
    }

    public boolean isPermittedRequest(HttpServletRequest request) {
        String remoteAddress = request.getRemoteAddr();
        return this.isPermittedRequest(remoteAddress);
    }

    public boolean isPermittedRequest(String remoteAddress) {
        boolean ipV6;
        boolean bl = ipV6 = remoteAddress != null && remoteAddress.indexOf(58) != -1;
        if (ipV6 && this.denyList.size() == 0 && this.allowList.size() == 0) {
            return true;
        }
        IPAddress ipAddress = new IPAddress(remoteAddress);
        for (IPRange range : this.denyList) {
            if (!range.isIPAddressInRange(ipAddress)) continue;
            return false;
        }
        if (this.allowList.size() > 0) {
            for (IPRange range : this.allowList) {
                if (!range.isIPAddressInRange(ipAddress)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        if (!this.isPermittedRequest(request)) {
            path = "/nopermit.html";
            this.returnResourceFile(path, uri, response);
            return;
        }
        if ("/submitLogin".equals(path)) {
            String usernameParam = request.getParameter(PARAM_NAME_USERNAME);
            String passwordParam = request.getParameter(PARAM_NAME_PASSWORD);
            if (this.username.equals(usernameParam) && this.password.equals(passwordParam)) {
                request.getSession().setAttribute(SESSION_USER_KEY, (Object)this.username);
                response.getWriter().print("success");
            } else {
                response.getWriter().print("error");
            }
            return;
        }
        if (!(!this.isRequireAuth() || session.getAttribute(SESSION_USER_KEY) != null || "/login.html".equals(path) || path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/img"))) {
            if (contextPath == null || contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect("/login.html");
            } else {
                response.sendRedirect("login.html");
            }
            return;
        }
        if ("".equals(path)) {
            if (contextPath == null || contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect("/druid/index.html");
            } else {
                response.sendRedirect("druid/index.html");
            }
            return;
        }
        if ("/".equals(path)) {
            response.sendRedirect("index.html");
            return;
        }
        if (path.indexOf(".json") >= 0) {
            String fullUrl = path;
            if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                fullUrl = fullUrl + "?" + request.getQueryString();
            }
            response.getWriter().print(this.statService.service(fullUrl));
            return;
        }
        this.returnResourceFile(path, uri, response);
    }

    private void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        if (fileName.endsWith(".jpg")) {
            byte[] bytes = IOUtils.readByteArrayFromResource(RESOURCE_PATH + fileName);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = IOUtils.readFromResource(RESOURCE_PATH + fileName);
        if (text == null) {
            response.sendRedirect(uri + "/index.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        }
        response.getWriter().write(text);
    }
}

