/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.util;

import com.alibaba.druid.support.http.util.IPAddress;

public class IPRange {
    private IPAddress ipAddress = null;
    private IPAddress ipSubnetMask = null;
    private int extendedNetworkPrefix = 0;

    public IPRange(String range) {
        this.parseRange(range);
    }

    public IPRange(IPAddress ipAddress, IPAddress subnetMask) {
        if (ipAddress == null || subnetMask == null) {
            throw new IllegalArgumentException();
        }
        this.ipAddress = ipAddress;
        this.ipSubnetMask = subnetMask;
        this.extendedNetworkPrefix = this.computeNetworkPrefixFromMask(subnetMask);
        if (this.extendedNetworkPrefix == -1) {
            throw new IllegalArgumentException();
        }
    }

    public IPRange(IPAddress ipAddress, int extendedNetworkPrefix) {
        if (ipAddress == null) {
            throw new IllegalArgumentException();
        }
        if (extendedNetworkPrefix < 0 || extendedNetworkPrefix > 32) {
            throw new IllegalArgumentException();
        }
        this.ipAddress = ipAddress;
        this.extendedNetworkPrefix = extendedNetworkPrefix;
        this.ipSubnetMask = this.computeMaskFromNetworkPrefix(extendedNetworkPrefix);
    }

    public final IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public final IPAddress getIPSubnetMask() {
        return this.ipSubnetMask;
    }

    public final int getExtendedNetworkPrefix() {
        return this.extendedNetworkPrefix;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.ipAddress.toString());
        result.append("/");
        result.append(this.extendedNetworkPrefix);
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.extendedNetworkPrefix;
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.ipSubnetMask == null ? 0 : this.ipSubnetMask.hashCode());
        return result;
    }

    public boolean equals(Object another) {
        if (another instanceof IPRange) {
            IPRange range = (IPRange)another;
            return this.ipAddress.equals(range.getIPAddress()) && this.extendedNetworkPrefix == range.extendedNetworkPrefix;
        }
        return false;
    }

    final void parseRange(String range) {
        block7: {
            if (range == null) {
                throw new IllegalArgumentException("Invalid IP range");
            }
            int index = range.indexOf(47);
            String subnetStr = null;
            if (index == -1) {
                this.ipAddress = new IPAddress(range);
            } else {
                this.ipAddress = new IPAddress(range.substring(0, index));
                subnetStr = range.substring(index + 1);
            }
            try {
                if (subnetStr != null) {
                    this.extendedNetworkPrefix = Integer.parseInt(subnetStr);
                    if (this.extendedNetworkPrefix < 0 || this.extendedNetworkPrefix > 32) {
                        throw new IllegalArgumentException("Invalid IP range [" + range + "]");
                    }
                    this.ipSubnetMask = this.computeMaskFromNetworkPrefix(this.extendedNetworkPrefix);
                }
            }
            catch (NumberFormatException ex) {
                this.ipSubnetMask = new IPAddress(subnetStr);
                this.extendedNetworkPrefix = this.computeNetworkPrefixFromMask(this.ipSubnetMask);
                if (this.extendedNetworkPrefix != -1) break block7;
                throw new IllegalArgumentException("Invalid IP range [" + range + "]", ex);
            }
        }
    }

    private int computeNetworkPrefixFromMask(IPAddress mask) {
        int result = 0;
        int tmp = mask.getIPAddress();
        while ((tmp & 1) == 1) {
            ++result;
            tmp >>>= 1;
        }
        if (tmp != 0) {
            return -1;
        }
        return result;
    }

    public static String toDecimalString(String inBinaryIpAddress) {
        StringBuilder decimalip = new StringBuilder();
        String[] binary = new String[4];
        int i = 0;
        int c = 0;
        while (i < 32) {
            binary[c] = inBinaryIpAddress.substring(i, i + 8);
            int octet = Integer.parseInt(binary[c], 2);
            decimalip.append(octet);
            if (c < 3) {
                decimalip.append('.');
            }
            i += 8;
            ++c;
        }
        return decimalip.toString();
    }

    private IPAddress computeMaskFromNetworkPrefix(int prefix) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            if (i < prefix) {
                str.append("1");
                continue;
            }
            str.append("0");
        }
        String decimalString = IPRange.toDecimalString(str.toString());
        return new IPAddress(decimalString);
    }

    public boolean isIPAddressInRange(IPAddress address) {
        int result2;
        if (this.ipSubnetMask == null) {
            return this.ipAddress.equals(address);
        }
        int result1 = address.getIPAddress() & this.ipSubnetMask.getIPAddress();
        return result1 == (result2 = this.ipAddress.getIPAddress() & this.ipSubnetMask.getIPAddress());
    }
}

