/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.json;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONParser {
    private String text;
    private int index = 0;
    private char ch;
    private Token token;
    private String stringValue;
    private long longValue;
    private double doubleValue;

    public JSONParser(String text) {
        this.text = text;
        this.ch = text.charAt(0);
        this.nextToken();
    }

    public Object parse() {
        if (this.token == Token.LBRACE) {
            return this.parseMap();
        }
        if (this.token == Token.INT) {
            Number value = this.longValue >= Integer.MIN_VALUE && this.longValue <= Integer.MAX_VALUE ? (Number)((int)this.longValue) : (Number)this.longValue;
            this.nextToken();
            return value;
        }
        if (this.token == Token.DOUBLE) {
            Double value = this.doubleValue;
            this.nextToken();
            return value;
        }
        if (this.token == Token.STRING) {
            String value = this.stringValue;
            this.nextToken();
            return value;
        }
        if (this.token == Token.LBRACKET) {
            return this.parseArray();
        }
        if (this.token == Token.TRUE) {
            this.nextToken();
            return true;
        }
        if (this.token == Token.FALSE) {
            this.nextToken();
            return false;
        }
        if (this.token == Token.NULL) {
            this.nextToken();
            return null;
        }
        throw new IllegalArgumentException("illegal token : " + (Object)((Object)this.token));
    }

    public List<Object> parseArray() {
        this.accept(Token.LBRACKET);
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.token != Token.RBRACKET) {
            if (this.token == Token.COMMA) {
                this.nextToken();
                continue;
            }
            Object item = this.parse();
            list.add(item);
        }
        this.accept(Token.RBRACKET);
        return list;
    }

    public Map<String, Object> parseMap() {
        this.accept(Token.LBRACE);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (this.token != Token.RBRACE) {
            if (this.token == Token.COMMA) {
                this.nextToken();
                continue;
            }
            if (this.token != Token.STRING) {
                throw new IllegalArgumentException("illegal json, " + (Object)((Object)this.token) + " : " + this.text);
            }
            String key = this.stringValue;
            this.nextToken();
            this.accept(Token.COLON);
            Object value = this.parse();
            map.put(key, value);
        }
        this.accept(Token.RBRACE);
        return map;
    }

    void accept(Token token) {
        if (this.token == token) {
            this.nextToken();
            return;
        }
        throw new IllegalArgumentException("illegal token : " + (Object)((Object)token) + ", expect " + (Object)((Object)token));
    }

    final void nextToken() {
        if (this.index == Integer.MIN_VALUE) {
            this.token = Token.EOF;
            return;
        }
        while (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t') {
            this.nextChar();
        }
        if (this.index >= this.text.length()) {
            this.token = Token.EOF;
            return;
        }
        switch (this.ch) {
            case '{': {
                this.token = Token.LBRACE;
                this.nextChar();
                break;
            }
            case '}': {
                this.token = Token.RBRACE;
                this.nextChar();
                break;
            }
            case '[': {
                this.token = Token.LBRACKET;
                this.nextChar();
                break;
            }
            case ']': {
                this.token = Token.RBRACKET;
                this.nextChar();
                break;
            }
            case ',': {
                this.token = Token.COMMA;
                this.nextChar();
                break;
            }
            case ':': {
                this.token = Token.COLON;
                this.nextChar();
                break;
            }
            case '\"': {
                this.scanString();
                break;
            }
            default: {
                if (JSONParser.isDigit(this.ch) || this.ch == '-') {
                    this.scanDigit();
                    return;
                }
                if (this.text.startsWith("null", this.index)) {
                    this.token = Token.NULL;
                    this.index += 3;
                    this.nextChar();
                    return;
                }
                if (this.text.startsWith("true", this.index)) {
                    this.token = Token.TRUE;
                    this.index += 3;
                    this.nextChar();
                    return;
                }
                if (this.text.startsWith("false", this.index)) {
                    this.token = Token.FALSE;
                    this.index += 4;
                    this.nextChar();
                    return;
                }
                throw new IllegalArgumentException("illegal json char : " + this.ch);
            }
        }
    }

    private void scanDigit() {
        boolean isNegate = false;
        if (this.ch == '-') {
            isNegate = true;
            this.nextChar();
        }
        int dotCount = 0;
        StringBuilder digitBuf = new StringBuilder();
        while (true) {
            digitBuf.append(this.ch);
            this.nextChar();
            if (this.ch == '.') {
                ++dotCount;
                digitBuf.append('.');
                this.nextChar();
                continue;
            }
            if (!JSONParser.isDigit(this.ch)) break;
        }
        if (dotCount == 0) {
            long longValue = Long.parseLong(digitBuf.toString());
            if (isNegate) {
                longValue = -longValue;
            }
            this.longValue = longValue;
            this.token = Token.INT;
        } else {
            double doubleValue = Double.parseDouble(digitBuf.toString());
            if (isNegate) {
                doubleValue = -doubleValue;
            }
            this.doubleValue = doubleValue;
            this.token = Token.DOUBLE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanString() {
        this.nextChar();
        StringBuilder strBuf = new StringBuilder();
        while (true) {
            if (this.index >= this.text.length()) {
                throw new IllegalArgumentException("illegal string : " + strBuf);
            }
            if (this.ch == '\"') break;
            if (this.ch == '\\') {
                this.nextChar();
                if (this.ch == '\"' || this.ch == '\\' || this.ch == '/') {
                    strBuf.append(this.ch);
                } else if (this.ch == 'n') {
                    strBuf.append('\n');
                } else if (this.ch == 'r') {
                    strBuf.append('\r');
                } else if (this.ch == 'b') {
                    strBuf.append('\b');
                } else if (this.ch == 'f') {
                    strBuf.append('\f');
                } else {
                    if (this.ch != 't') throw new IllegalArgumentException("illegal string : " + strBuf);
                    strBuf.append('\t');
                }
            } else {
                strBuf.append(this.ch);
            }
            this.nextChar();
        }
        this.nextChar();
        this.stringValue = strBuf.toString();
        this.token = Token.STRING;
    }

    static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    void nextChar() {
        ++this.index;
        if (this.index >= this.text.length()) {
            this.index = Integer.MIN_VALUE;
            return;
        }
        this.ch = this.text.charAt(this.index);
    }

    static enum Token {
        INT,
        DOUBLE,
        STRING,
        BOOLEAN,
        TRUE,
        FALSE,
        NULL,
        EOF,
        LBRACE("{"),
        RBRACE("}"),
        LBRACKET("["),
        RBRACKET("]"),
        COMMA(","),
        COLON(":");

        public final String name;

        private Token() {
            this(null);
        }

        private Token(String name) {
            this.name = name;
        }
    }
}

