/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.monitor;

import com.alibaba.druid.stat.DruidStatManagerFacade;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.druid.support.spring.stat.SpringStatManager;
import com.alibaba.druid.util.DaemonThreadFactory;
import com.alibaba.druid.util.HttpClientUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PushService {
    private static final PushService instance = new PushService();
    private static final int DEFAULT_CYCLE_TIME = 300000;
    private static final int DEFAULT_PUSH_TIMEOUT = 60000;
    private final DruidStatManagerFacade statManagerFacade = DruidStatManagerFacade.getInstance();
    private final WebAppStatManager webAppStatManager = WebAppStatManager.getInstance();
    private final SpringStatManager springStatManager = SpringStatManager.getInstance();
    private String serverUrl;
    private boolean includeSql = true;
    private boolean includeWebApp = true;
    private boolean includeWebUri = true;
    private boolean includeWebSession = true;
    private boolean includeSpring = true;
    private boolean autoReset = true;
    private long cycleTime = 300000L;
    private long pushTimeOut = 60000L;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("DruidPullService-Scheduler"));
    private ScheduledFuture<?> executeFuture = null;

    private PushService() {
    }

    public static PushService getInstance() {
        return instance;
    }

    public void start() {
        this.executeFuture = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PushService.this.execute();
            }
        }, 0L, this.cycleTime, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.executeFuture != null && this.executeFuture.cancel(true)) {
            this.executeFuture = null;
        }
    }

    protected void execute() {
        Map<String, Object> data = this.collectAndReset();
        String json = JSONUtils.toJSONString(data);
        this.push("data=" + json);
    }

    protected Map<String, Object> collectAndReset() {
        List<Map<String, Object>> list;
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.includeSql) {
            List<Map<String, Object>> dataSources = this.statManagerFacade.getDataSourceStatDataList(true);
            data.put("DataSources", dataSources);
        }
        if (this.includeWebApp) {
            list = this.webAppStatManager.getWebAppStatData();
            data.put("WebApp", list);
        }
        if (this.includeWebUri) {
            list = this.webAppStatManager.getURIStatData();
            data.put("WebURI", list);
        }
        if (this.includeWebSession) {
            list = this.webAppStatManager.getSessionStatData();
            data.put("WebSession", list);
        }
        if (this.includeSpring) {
            list = this.springStatManager.getMethodStatData();
            data.put("Spring", list);
        }
        if (this.autoReset) {
            this.statManagerFacade.resetAll();
        }
        return data;
    }

    protected void push(String data) {
        HttpClientUtils.post(this.serverUrl, data, this.pushTimeOut);
    }

    public long getCycleTime() {
        return this.cycleTime;
    }

    public void setCycleTime(long cycleTime) {
        this.cycleTime = cycleTime;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isIncludeSql() {
        return this.includeSql;
    }

    public void setIncludeSql(boolean includeSql) {
        this.includeSql = includeSql;
    }

    public boolean isIncludeWebApp() {
        return this.includeWebApp;
    }

    public void setIncludeWebApp(boolean includeWebApp) {
        this.includeWebApp = includeWebApp;
    }

    public boolean isIncludeWebUri() {
        return this.includeWebUri;
    }

    public void setIncludeWebUri(boolean includeWebUri) {
        this.includeWebUri = includeWebUri;
    }

    public boolean isIncludeWebSession() {
        return this.includeWebSession;
    }

    public void setIncludeWebSession(boolean includeWebSession) {
        this.includeWebSession = includeWebSession;
    }

    public boolean isIncludeSpring() {
        return this.includeSpring;
    }

    public void setIncludeSpring(boolean includeSpring) {
        this.includeSpring = includeSpring;
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }
}

