/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.util.StringUtils;

public class CellData {
    private CellDataTypeEnum type;
    private Double doubleValue;
    private String stringValue;
    private Boolean booleanValue;
    private Boolean formula;
    private String formulaValue;
    private byte[] imageValue;
    private Integer dataFormat;
    private String dataFormatString;

    public CellData(CellData other) {
        this.type = other.type;
        this.doubleValue = other.doubleValue;
        this.stringValue = other.stringValue;
        this.booleanValue = other.booleanValue;
        this.formula = other.formula;
        this.formulaValue = other.formulaValue;
        this.imageValue = other.imageValue;
        this.dataFormat = other.dataFormat;
        this.dataFormatString = other.dataFormatString;
    }

    public CellData(String stringValue) {
        this(CellDataTypeEnum.STRING, stringValue);
    }

    public CellData(CellDataTypeEnum type, String stringValue) {
        if (type != CellDataTypeEnum.STRING && type != CellDataTypeEnum.ERROR) {
            throw new IllegalArgumentException("Only support CellDataTypeEnum.STRING and  CellDataTypeEnum.ERROR");
        }
        if (stringValue == null) {
            throw new IllegalArgumentException("StringValue can not be null");
        }
        this.type = type;
        this.stringValue = stringValue;
        this.formula = Boolean.FALSE;
    }

    public CellData(Double doubleValue) {
        if (doubleValue == null) {
            throw new IllegalArgumentException("DoubleValue can not be null");
        }
        this.type = CellDataTypeEnum.NUMBER;
        this.doubleValue = doubleValue;
        this.formula = Boolean.FALSE;
    }

    public CellData(byte[] imageValue) {
        if (imageValue == null) {
            throw new IllegalArgumentException("ImageValue can not be null");
        }
        this.type = CellDataTypeEnum.IMAGE;
        this.imageValue = imageValue;
        this.formula = Boolean.FALSE;
    }

    public CellData(Boolean booleanValue) {
        if (booleanValue == null) {
            throw new IllegalArgumentException("BooleanValue can not be null");
        }
        this.type = CellDataTypeEnum.BOOLEAN;
        this.booleanValue = booleanValue;
        this.formula = Boolean.FALSE;
    }

    public CellData(CellDataTypeEnum type) {
        if (type == null) {
            throw new IllegalArgumentException("Type can not be null");
        }
        this.type = type;
        this.formula = Boolean.FALSE;
    }

    public CellDataTypeEnum getType() {
        return this.type;
    }

    public void setType(CellDataTypeEnum type) {
        this.type = type;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public Boolean getFormula() {
        return this.formula;
    }

    public void setFormula(Boolean formula) {
        this.formula = formula;
    }

    public String getFormulaValue() {
        return this.formulaValue;
    }

    public void setFormulaValue(String formulaValue) {
        this.formulaValue = formulaValue;
    }

    public byte[] getImageValue() {
        return this.imageValue;
    }

    public void setImageValue(byte[] imageValue) {
        this.imageValue = imageValue;
    }

    public Integer getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(Integer dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getDataFormatString() {
        return this.dataFormatString;
    }

    public void setDataFormatString(String dataFormatString) {
        this.dataFormatString = dataFormatString;
    }

    public void checkEmpty() {
        switch (this.type) {
            case STRING: 
            case ERROR: {
                if (StringUtils.isEmpty(this.stringValue)) {
                    this.type = CellDataTypeEnum.EMPTY;
                }
                return;
            }
            case NUMBER: {
                if (this.doubleValue == null) {
                    this.type = CellDataTypeEnum.EMPTY;
                }
                return;
            }
            case BOOLEAN: {
                if (this.booleanValue == null) {
                    this.type = CellDataTypeEnum.EMPTY;
                }
                return;
            }
        }
    }

    public String toString() {
        switch (this.type) {
            case NUMBER: {
                return this.doubleValue.toString();
            }
            case BOOLEAN: {
                return this.booleanValue.toString();
            }
            case STRING: 
            case ERROR: {
                return this.stringValue;
            }
        }
        return "empty";
    }
}

