/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.core.env;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.spring.context.config.xml.NacosPropertySourceXmlBeanDefinition;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import com.alibaba.nacos.spring.core.env.AbstractNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlNacosPropertySourceBuilder
extends AbstractNacosPropertySourceBuilder<NacosPropertySourceXmlBeanDefinition> {
    public static final String BEAN_NAME = "xmlNacosPropertySourceBuilder";

    @Override
    protected Map<String, Object>[] resolveRuntimeAttributesArray(NacosPropertySourceXmlBeanDefinition beanDefinition, Properties globalNacosProperties) {
        Element element = beanDefinition.getElement();
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>(4);
        runtimeAttributes.put("dataId", this.getAttribute(element, "data-id", ""));
        runtimeAttributes.put("groupId", this.getAttribute(element, "group-id", "DEFAULT_GROUP"));
        runtimeAttributes.put("name", this.getAttribute(element, "name", ""));
        runtimeAttributes.put("autoRefreshed", this.getAttribute(element, "autoRefreshed", false));
        runtimeAttributes.put("first", this.getAttribute(element, "first", false));
        runtimeAttributes.put("before", this.getAttribute(element, "before", ""));
        runtimeAttributes.put("after", this.getAttribute(element, "after", ""));
        String type = this.getAttribute(element, "type", "properties");
        try {
            runtimeAttributes.put("type", ConfigType.valueOf((String)type.toUpperCase()));
            runtimeAttributes.put("properties", new Properties());
            return new Map[]{runtimeAttributes};
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Now the config type just support [properties, json, yaml, xml, text, html]");
        }
    }

    @Override
    protected void initNacosPropertySource(NacosPropertySource nacosPropertySource, NacosPropertySourceXmlBeanDefinition beanDefinition, Map<String, Object> attributes) {
        Element element = beanDefinition.getElement();
        this.initAttributesMetadata(nacosPropertySource, element);
        this.initOrigin(nacosPropertySource, beanDefinition.getXmlReaderContext());
        this.initAutoRefreshed(nacosPropertySource, element);
        this.initOrder(nacosPropertySource, element);
    }

    private void initOrigin(NacosPropertySource nacosPropertySource, XmlReaderContext xmlReaderContext) {
        Resource resource = xmlReaderContext.getResource();
        nacosPropertySource.setOrigin(resource);
    }

    private void initAutoRefreshed(NacosPropertySource nacosPropertySource, Element element) {
        boolean autoRefreshed = this.getAttribute(element, "auto-refreshed", false);
        nacosPropertySource.setAutoRefreshed(autoRefreshed);
    }

    private void initAttributesMetadata(NacosPropertySource nacosPropertySource, Element element) {
        NamedNodeMap elementAttributes = element.getAttributes();
        int length = elementAttributes.getLength();
    }

    private void initOrder(NacosPropertySource nacosPropertySource, Element element) {
        boolean first = this.getAttribute(element, "first", false);
        String before = this.getAttribute(element, "before", "");
        String after = this.getAttribute(element, "after", "");
        nacosPropertySource.setFirst(first);
        nacosPropertySource.setBefore(before);
        nacosPropertySource.setAfter(after);
    }

    private <T> T getAttribute(Element element, String name, T defaultValue) {
        ConfigurableConversionService conversionService = this.environment.getConversionService();
        String value = element.getAttribute(name);
        String resolvedValue = this.environment.resolvePlaceholders(value);
        T attributeValue = StringUtils.hasText((String)resolvedValue) ? conversionService.convert((Object)resolvedValue, defaultValue.getClass()) : defaultValue;
        return attributeValue;
    }

    @Override
    protected NacosConfigMetadataEvent createMetaEvent(NacosPropertySource nacosPropertySource, NacosPropertySourceXmlBeanDefinition beanDefinition) {
        return new NacosConfigMetadataEvent(beanDefinition.getElement());
    }

    @Override
    protected void doInitMetadataEvent(NacosPropertySource nacosPropertySource, NacosPropertySourceXmlBeanDefinition beanDefinition, NacosConfigMetadataEvent metadataEvent) {
        metadataEvent.setXmlResource(beanDefinition.getXmlReaderContext().getResource());
    }
}

