/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nls.client.AccessTokenType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessToken {
    private static final String NLS_DOMAIN = "nls-meta.cn-shanghai.aliyuncs.com";
    private static final String NLS_VERSION = "2019-02-28";
    private static final String MCOS_DOMAIN = "mcos.cn-shanghai.aliyuncs.com";
    private static final String MCOS_VERSION = "2022-08-11";
    private static final String TIME_ZONE = "GMT";
    private static final String FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String URL_ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "HmacSHA1";
    private static final String ENCODING = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(AccessToken.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String domain = "";
    private String regionId = "cn-shanghai";
    private String version = "";
    private String action = "CreateToken";
    private String token;
    private long expireTime;

    public AccessToken(String accessKeyId, String accessKeySecret) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.domain = NLS_DOMAIN;
        this.version = NLS_VERSION;
    }

    public AccessToken(String accessKeyId, String accessKeySecret, AccessTokenType type) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        if (AccessTokenType.MCOS.equals((Object)type)) {
            this.domain = MCOS_DOMAIN;
            this.version = MCOS_VERSION;
        } else {
            this.domain = NLS_DOMAIN;
            this.version = NLS_VERSION;
        }
    }

    public AccessToken(String accessKeyId, String accessKeySecret, String domain, String regionId, String version) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.domain = domain;
        this.regionId = regionId;
        this.version = version;
    }

    private String getISO8601Time(Date date) {
        Date nowDate = date;
        if (null == date) {
            nowDate = new Date();
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_ISO8601);
        df.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        return df.format(nowDate);
    }

    private String getUniqueNonce() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    private String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    private String canonicalizedQuery(Map<String, String> queryParamsMap) {
        Object[] sortedKeys = queryParamsMap.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        String queryString = null;
        try {
            StringBuilder canonicalizedQueryString = new StringBuilder();
            for (Object key : sortedKeys) {
                canonicalizedQueryString.append("&").append(this.percentEncode((String)key)).append("=").append(this.percentEncode(queryParamsMap.get(key)));
            }
            queryString = canonicalizedQueryString.toString().substring(1);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UTF-8 encoding is not supported.");
            e.printStackTrace();
        }
        return queryString;
    }

    private String createStringToSign(String method, String urlPath, String queryString) {
        String stringToSign = null;
        try {
            StringBuilder strBuilderSign = new StringBuilder();
            strBuilderSign.append(method);
            strBuilderSign.append("&");
            strBuilderSign.append(this.percentEncode(urlPath));
            strBuilderSign.append("&");
            strBuilderSign.append(this.percentEncode(queryString));
            stringToSign = strBuilderSign.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UTF-8 encoding is not supported.");
            e.printStackTrace();
        }
        return stringToSign;
    }

    private String sign(String stringToSign, String accessKeySecret) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM_NAME);
            mac.init(new SecretKeySpec(accessKeySecret.getBytes("UTF-8"), ALGORITHM_NAME));
            byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
            String signBase64 = DatatypeConverter.printBase64Binary((byte[])signData);
            String signUrlEncode = this.percentEncode(signBase64);
            return signUrlEncode;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    private void processGETRequest(String queryString) {
        String url = "http://" + this.domain;
        url = url + "/";
        url = url + "?" + queryString;
        Request request = new Request.Builder().url(url).header("Accept", "application/json").get().build();
        try {
            OkHttpClient client = new OkHttpClient();
            Response response = client.newCall(request).execute();
            String result = response.body().string();
            if (response.isSuccessful()) {
                JSONObject rootObj = JSON.parseObject((String)result);
                JSONObject tokenObj = rootObj.getJSONObject("Token");
                if (tokenObj != null) {
                    this.token = tokenObj.getString("Id");
                    this.expireTime = tokenObj.getLongValue("ExpireTime");
                } else {
                    logger.error("Create the token failed: " + result);
                }
            } else {
                System.err.println("Create the token failed: " + result);
            }
            response.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void apply() throws IOException {
        HashMap<String, String> queryParamsMap = new HashMap<String, String>();
        queryParamsMap.put("AccessKeyId", this.accessKeyId);
        queryParamsMap.put("Action", this.action);
        queryParamsMap.put("Version", this.version);
        queryParamsMap.put("RegionId", this.regionId);
        queryParamsMap.put("Timestamp", this.getISO8601Time(null));
        queryParamsMap.put("Format", "JSON");
        queryParamsMap.put("SignatureMethod", "HMAC-SHA1");
        queryParamsMap.put("SignatureVersion", "1.0");
        queryParamsMap.put("SignatureNonce", this.getUniqueNonce());
        String queryString = this.canonicalizedQuery(queryParamsMap);
        if (null == queryString) {
            logger.error("create the canonicalized query failed");
            return;
        }
        String method = "GET";
        String urlPath = "/";
        String stringToSign = this.createStringToSign(method, urlPath, queryString);
        if (null == stringToSign) {
            logger.error("create the sign string failed");
            return;
        }
        String signature = this.sign(stringToSign, this.accessKeySecret + "&");
        if (null == signature) {
            logger.error("computer the sign failed!");
            return;
        }
        String queryStringWithSign = "Signature=" + signature + "&" + queryString;
        this.processGETRequest(queryStringWithSign);
    }

    public String getToken() {
        return this.token;
    }

    public long getExpireTime() {
        return this.expireTime;
    }
}

