/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddWatermarkRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    private String appId;
    @Query
    @NameInMap(value="FileUrl")
    private String fileUrl;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;
    @Query
    @NameInMap(value="WatermarkConfig")
    @Validation(required=true)
    private String watermarkConfig;

    private AddWatermarkRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.fileUrl = builder.fileUrl;
        this.name = builder.name;
        this.type = builder.type;
        this.watermarkConfig = builder.watermarkConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddWatermarkRequest create() {
        return AddWatermarkRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getWatermarkConfig() {
        return this.watermarkConfig;
    }

    public static final class Builder
    extends Request.Builder<AddWatermarkRequest, Builder> {
        private String appId;
        private String fileUrl;
        private String name;
        private String type;
        private String watermarkConfig;

        private Builder() {
        }

        private Builder(AddWatermarkRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.fileUrl = request.fileUrl;
            this.name = request.name;
            this.type = request.type;
            this.watermarkConfig = request.watermarkConfig;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder fileUrl(String fileUrl) {
            this.putQueryParameter("FileUrl", fileUrl);
            this.fileUrl = fileUrl;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public Builder watermarkConfig(String watermarkConfig) {
            this.putQueryParameter("WatermarkConfig", watermarkConfig);
            this.watermarkConfig = watermarkConfig;
            return this;
        }

        public AddWatermarkRequest build() {
            return new AddWatermarkRequest(this);
        }
    }
}

