/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ChangeResourceGroupRequest
extends Request {
    @Query
    @NameInMap(value="ResourceGroupId")
    @Validation(required=true)
    private String resourceGroupId;
    @Query
    @NameInMap(value="ResourceId")
    @Validation(required=true)
    private String resourceId;
    @Query
    @NameInMap(value="ResourceRegionId")
    @Validation(required=true)
    private String resourceRegionId;
    @Query
    @NameInMap(value="ResourceType")
    private String resourceType;

    private ChangeResourceGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.resourceGroupId = builder.resourceGroupId;
        this.resourceId = builder.resourceId;
        this.resourceRegionId = builder.resourceRegionId;
        this.resourceType = builder.resourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ChangeResourceGroupRequest create() {
        return ChangeResourceGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceRegionId() {
        return this.resourceRegionId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public static final class Builder
    extends Request.Builder<ChangeResourceGroupRequest, Builder> {
        private String resourceGroupId;
        private String resourceId;
        private String resourceRegionId;
        private String resourceType;

        private Builder() {
        }

        private Builder(ChangeResourceGroupRequest request) {
            super((Request)request);
            this.resourceGroupId = request.resourceGroupId;
            this.resourceId = request.resourceId;
            this.resourceRegionId = request.resourceRegionId;
            this.resourceType = request.resourceType;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.putQueryParameter("ResourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceRegionId(String resourceRegionId) {
            this.putQueryParameter("ResourceRegionId", resourceRegionId);
            this.resourceRegionId = resourceRegionId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public ChangeResourceGroupRequest build() {
            return new ChangeResourceGroupRequest(this);
        }
    }
}

