/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateAppInfoRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;

    private CreateAppInfoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.description = builder.description;
        this.resourceGroupId = builder.resourceGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateAppInfoRequest create() {
        return CreateAppInfoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public static final class Builder
    extends Request.Builder<CreateAppInfoRequest, Builder> {
        private String appName;
        private String description;
        private String resourceGroupId;

        private Builder() {
        }

        private Builder(CreateAppInfoRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.description = request.description;
            this.resourceGroupId = request.resourceGroupId;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public CreateAppInfoRequest build() {
            return new CreateAppInfoRequest(this);
        }
    }
}

