/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateUploadImageRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    private String appId;
    @Query
    @NameInMap(value="CateId")
    private Long cateId;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="ImageExt")
    private String imageExt;
    @Query
    @NameInMap(value="ImageType")
    @Validation(required=true)
    private String imageType;
    @Query
    @NameInMap(value="OriginalFileName")
    private String originalFileName;
    @Query
    @NameInMap(value="StorageLocation")
    private String storageLocation;
    @Query
    @NameInMap(value="Tags")
    private String tags;
    @Query
    @NameInMap(value="Title")
    private String title;
    @Query
    @NameInMap(value="UserData")
    private String userData;

    private CreateUploadImageRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.cateId = builder.cateId;
        this.description = builder.description;
        this.imageExt = builder.imageExt;
        this.imageType = builder.imageType;
        this.originalFileName = builder.originalFileName;
        this.storageLocation = builder.storageLocation;
        this.tags = builder.tags;
        this.title = builder.title;
        this.userData = builder.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateUploadImageRequest create() {
        return CreateUploadImageRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getCateId() {
        return this.cateId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImageExt() {
        return this.imageExt;
    }

    public String getImageType() {
        return this.imageType;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public String getTags() {
        return this.tags;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUserData() {
        return this.userData;
    }

    public static final class Builder
    extends Request.Builder<CreateUploadImageRequest, Builder> {
        private String appId;
        private Long cateId;
        private String description;
        private String imageExt;
        private String imageType;
        private String originalFileName;
        private String storageLocation;
        private String tags;
        private String title;
        private String userData;

        private Builder() {
        }

        private Builder(CreateUploadImageRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.cateId = request.cateId;
            this.description = request.description;
            this.imageExt = request.imageExt;
            this.imageType = request.imageType;
            this.originalFileName = request.originalFileName;
            this.storageLocation = request.storageLocation;
            this.tags = request.tags;
            this.title = request.title;
            this.userData = request.userData;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder cateId(Long cateId) {
            this.putQueryParameter("CateId", cateId);
            this.cateId = cateId;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder imageExt(String imageExt) {
            this.putQueryParameter("ImageExt", imageExt);
            this.imageExt = imageExt;
            return this;
        }

        public Builder imageType(String imageType) {
            this.putQueryParameter("ImageType", imageType);
            this.imageType = imageType;
            return this;
        }

        public Builder originalFileName(String originalFileName) {
            this.putQueryParameter("OriginalFileName", originalFileName);
            this.originalFileName = originalFileName;
            return this;
        }

        public Builder storageLocation(String storageLocation) {
            this.putQueryParameter("StorageLocation", storageLocation);
            this.storageLocation = storageLocation;
            return this;
        }

        public Builder tags(String tags) {
            this.putQueryParameter("Tags", tags);
            this.tags = tags;
            return this;
        }

        public Builder title(String title) {
            this.putQueryParameter("Title", title);
            this.title = title;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public CreateUploadImageRequest build() {
            return new CreateUploadImageRequest(this);
        }
    }
}

