/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListLiveRecordVideoRequest
extends Request {
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="DomainName")
    private String domainName;
    @Query
    @NameInMap(value="EndTime")
    private String endTime;
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;
    @Query
    @NameInMap(value="StartTime")
    private String startTime;
    @Query
    @NameInMap(value="StreamName")
    private String streamName;

    private ListLiveRecordVideoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.domainName = builder.domainName;
        this.endTime = builder.endTime;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.startTime = builder.startTime;
        this.streamName = builder.streamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveRecordVideoRequest create() {
        return ListLiveRecordVideoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public static final class Builder
    extends Request.Builder<ListLiveRecordVideoRequest, Builder> {
        private String appName;
        private String domainName;
        private String endTime;
        private Integer pageNo;
        private Integer pageSize;
        private String sortBy;
        private String startTime;
        private String streamName;

        private Builder() {
        }

        private Builder(ListLiveRecordVideoRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.domainName = request.domainName;
            this.endTime = request.endTime;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
            this.startTime = request.startTime;
            this.streamName = request.streamName;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder streamName(String streamName) {
            this.putQueryParameter("StreamName", streamName);
            this.streamName = streamName;
            return this;
        }

        public ListLiveRecordVideoRequest build() {
            return new ListLiveRecordVideoRequest(this);
        }
    }
}

