/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SearchMediaRequest
extends Request {
    @Query
    @NameInMap(value="Fields")
    private String fields;
    @Query
    @NameInMap(value="Match")
    private String match;
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="ScrollToken")
    private String scrollToken;
    @Query
    @NameInMap(value="SearchType")
    private String searchType;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;

    private SearchMediaRequest(Builder builder) {
        super((Request.Builder)builder);
        this.fields = builder.fields;
        this.match = builder.match;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.scrollToken = builder.scrollToken;
        this.searchType = builder.searchType;
        this.sortBy = builder.sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchMediaRequest create() {
        return SearchMediaRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getFields() {
        return this.fields;
    }

    public String getMatch() {
        return this.match;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getScrollToken() {
        return this.scrollToken;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public static final class Builder
    extends Request.Builder<SearchMediaRequest, Builder> {
        private String fields;
        private String match;
        private Integer pageNo;
        private Integer pageSize;
        private String scrollToken;
        private String searchType;
        private String sortBy;

        private Builder() {
        }

        private Builder(SearchMediaRequest request) {
            super((Request)request);
            this.fields = request.fields;
            this.match = request.match;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.scrollToken = request.scrollToken;
            this.searchType = request.searchType;
            this.sortBy = request.sortBy;
        }

        public Builder fields(String fields) {
            this.putQueryParameter("Fields", fields);
            this.fields = fields;
            return this;
        }

        public Builder match(String match) {
            this.putQueryParameter("Match", match);
            this.match = match;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder scrollToken(String scrollToken) {
            this.putQueryParameter("ScrollToken", scrollToken);
            this.scrollToken = scrollToken;
            return this;
        }

        public Builder searchType(String searchType) {
            this.putQueryParameter("SearchType", searchType);
            this.searchType = searchType;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public SearchMediaRequest build() {
            return new SearchMediaRequest(this);
        }
    }
}

