/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SetCrossdomainContentRequest
extends Request {
    @Query
    @NameInMap(value="Content")
    @Validation(required=true)
    private String content;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private String ownerId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private String resourceOwnerId;
    @Query
    @NameInMap(value="ResourceRealOwnerId")
    private String resourceRealOwnerId;
    @Query
    @NameInMap(value="StorageLocation")
    @Validation(required=true)
    private String storageLocation;

    private SetCrossdomainContentRequest(Builder builder) {
        super((Request.Builder)builder);
        this.content = builder.content;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceRealOwnerId = builder.resourceRealOwnerId;
        this.storageLocation = builder.storageLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetCrossdomainContentRequest create() {
        return SetCrossdomainContentRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getContent() {
        return this.content;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public String getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getResourceRealOwnerId() {
        return this.resourceRealOwnerId;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public static final class Builder
    extends Request.Builder<SetCrossdomainContentRequest, Builder> {
        private String content;
        private String ownerAccount;
        private String ownerId;
        private String resourceOwnerAccount;
        private String resourceOwnerId;
        private String resourceRealOwnerId;
        private String storageLocation;

        private Builder() {
        }

        private Builder(SetCrossdomainContentRequest request) {
            super((Request)request);
            this.content = request.content;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.resourceRealOwnerId = request.resourceRealOwnerId;
            this.storageLocation = request.storageLocation;
        }

        public Builder content(String content) {
            this.putQueryParameter("Content", content);
            this.content = content;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(String resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder resourceRealOwnerId(String resourceRealOwnerId) {
            this.putQueryParameter("ResourceRealOwnerId", resourceRealOwnerId);
            this.resourceRealOwnerId = resourceRealOwnerId;
            return this;
        }

        public Builder storageLocation(String storageLocation) {
            this.putQueryParameter("StorageLocation", storageLocation);
            this.storageLocation = storageLocation;
            return this;
        }

        public SetCrossdomainContentRequest build() {
            return new SetCrossdomainContentRequest(this);
        }
    }
}

