/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateAppInfoRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Status")
    private String status;

    private UpdateAppInfoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.appName = builder.appName;
        this.description = builder.description;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateAppInfoRequest create() {
        return UpdateAppInfoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStatus() {
        return this.status;
    }

    public static final class Builder
    extends Request.Builder<UpdateAppInfoRequest, Builder> {
        private String appId;
        private String appName;
        private String description;
        private String status;

        private Builder() {
        }

        private Builder(UpdateAppInfoRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.appName = request.appName;
            this.description = request.description;
            this.status = request.status;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public UpdateAppInfoRequest build() {
            return new UpdateAppInfoRequest(this);
        }
    }
}

