/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UploadMediaByURLRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    private String appId;
    @Query
    @NameInMap(value="SessionId")
    private String sessionId;
    @Query
    @NameInMap(value="StorageLocation")
    private String storageLocation;
    @Query
    @NameInMap(value="TemplateGroupId")
    private String templateGroupId;
    @Query
    @NameInMap(value="UploadMetadatas")
    private String uploadMetadatas;
    @Query
    @NameInMap(value="UploadURLs")
    @Validation(required=true)
    private String uploadURLs;
    @Query
    @NameInMap(value="UserData")
    private String userData;
    @Query
    @NameInMap(value="WorkflowId")
    private String workflowId;

    private UploadMediaByURLRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.sessionId = builder.sessionId;
        this.storageLocation = builder.storageLocation;
        this.templateGroupId = builder.templateGroupId;
        this.uploadMetadatas = builder.uploadMetadatas;
        this.uploadURLs = builder.uploadURLs;
        this.userData = builder.userData;
        this.workflowId = builder.workflowId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UploadMediaByURLRequest create() {
        return UploadMediaByURLRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public String getTemplateGroupId() {
        return this.templateGroupId;
    }

    public String getUploadMetadatas() {
        return this.uploadMetadatas;
    }

    public String getUploadURLs() {
        return this.uploadURLs;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public static final class Builder
    extends Request.Builder<UploadMediaByURLRequest, Builder> {
        private String appId;
        private String sessionId;
        private String storageLocation;
        private String templateGroupId;
        private String uploadMetadatas;
        private String uploadURLs;
        private String userData;
        private String workflowId;

        private Builder() {
        }

        private Builder(UploadMediaByURLRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.sessionId = request.sessionId;
            this.storageLocation = request.storageLocation;
            this.templateGroupId = request.templateGroupId;
            this.uploadMetadatas = request.uploadMetadatas;
            this.uploadURLs = request.uploadURLs;
            this.userData = request.userData;
            this.workflowId = request.workflowId;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.putQueryParameter("SessionId", sessionId);
            this.sessionId = sessionId;
            return this;
        }

        public Builder storageLocation(String storageLocation) {
            this.putQueryParameter("StorageLocation", storageLocation);
            this.storageLocation = storageLocation;
            return this;
        }

        public Builder templateGroupId(String templateGroupId) {
            this.putQueryParameter("TemplateGroupId", templateGroupId);
            this.templateGroupId = templateGroupId;
            return this;
        }

        public Builder uploadMetadatas(String uploadMetadatas) {
            this.putQueryParameter("UploadMetadatas", uploadMetadatas);
            this.uploadMetadatas = uploadMetadatas;
            return this;
        }

        public Builder uploadURLs(String uploadURLs) {
            this.putQueryParameter("UploadURLs", uploadURLs);
            this.uploadURLs = uploadURLs;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public Builder workflowId(String workflowId) {
            this.putQueryParameter("WorkflowId", workflowId);
            this.workflowId = workflowId;
            return this;
        }

        public UploadMediaByURLRequest build() {
            return new UploadMediaByURLRequest(this);
        }
    }
}

