/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.mapred.JobRunner;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.pipeline.Pipeline;
import com.aliyun.odps.utils.ReflectionUtils;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobClient {
    private static final Log LOG = LogFactory.getLog(JobClient.class);

    public static RunningJob runJob(JobConf job) throws OdpsException {
        Long baseTime = new Date().getTime();
        RunningJob rJob = JobClient.submitJob(job, baseTime);
        rJob.waitForCompletion();
        if (!rJob.isSuccessful()) {
            throw new OdpsException(rJob.getDiagnostics());
        }
        return rJob;
    }

    public static RunningJob runJob(JobConf job, Pipeline pipeline) throws OdpsException {
        Pipeline.toJobConf(job, pipeline);
        return JobClient.runJob(job);
    }

    public static RunningJob submitJob(JobConf job) throws OdpsException {
        return JobClient.submitJob(job, 0L);
    }

    public static RunningJob submitJob(JobConf job, Pipeline pipeline) throws OdpsException {
        Pipeline.toJobConf(job, pipeline);
        return JobClient.submitJob(job);
    }

    private static RunningJob submitJob(JobConf job, Long baseTime) throws OdpsException {
        SessionState ss = SessionState.get();
        String runner = null;
        runner = ss.isLocalRun() ? "com.aliyun.odps.mapred.LocalJobRunner" : (ss.isSqlMode() ? "com.aliyun.odps.mapred.SqlBridgeJobRunner" : "com.aliyun.odps.mapred.LotBridgeJobRunner");
        JobRunner jobrunner = null;
        try {
            Class<?> clz = Class.forName(runner);
            jobrunner = (JobRunner)ReflectionUtils.newInstance(clz, (Configuration)job);
        }
        catch (ClassNotFoundException e) {
            LOG.fatal((Object)"Internal error: corrupted installation.", (Throwable)e);
            throw new RuntimeException(e);
        }
        RunningJob rj = jobrunner.submit();
        System.out.println("InstanceId: " + rj.getInstanceID());
        return rj;
    }
}

