/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.example;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.Job;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.pipeline.Pipeline;
import java.io.IOException;
import java.util.Iterator;

public class OrderedWordCount {
    public static void main(String[] args) throws OdpsException {
        if (args.length != 2) {
            System.err.println("Usage: orderedwordcount <in_table> <out_table>");
            System.exit(2);
        }
        Job job = new Job();
        Pipeline pipeline = Pipeline.builder().addMapper(TokenizerMapper.class).setOutputKeySchema(new Column[]{new Column("word", OdpsType.STRING)}).setOutputValueSchema(new Column[]{new Column("count", OdpsType.BIGINT)}).setOutputKeySortColumns(new String[]{"word"}).setPartitionColumns(new String[]{"word"}).setOutputGroupingColumns(new String[]{"word"}).addReducer(SumReducer.class).setOutputKeySchema(new Column[]{new Column("count", OdpsType.BIGINT)}).setOutputValueSchema(new Column[]{new Column("word", OdpsType.STRING), new Column("count", OdpsType.BIGINT)}).addReducer(IdentityReducer.class).createPipeline();
        job.setPipeline(pipeline);
        job.addInput(TableInfo.builder().tableName(args[0]).build());
        job.addOutput(TableInfo.builder().tableName(args[1]).build());
        job.submit();
        job.waitForCompletion();
        System.exit(job.isSuccessful() ? 0 : 1);
    }

    public static class IdentityReducer
    extends ReducerBase {
        @Override
        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            while (values.hasNext()) {
                context.write(values.next());
            }
        }
    }

    public static class SumReducer
    extends ReducerBase {
        private Record num;
        private Record result;

        @Override
        public void setup(Reducer.TaskContext context) throws IOException {
            this.num = context.createOutputKeyRecord();
            this.result = context.createOutputValueRecord();
        }

        @Override
        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            this.result.set(0, key.get(0));
            this.result.set(1, (Object)count);
            this.num.set(0, (Object)count);
            context.write(this.num, this.result);
        }
    }

    public static class TokenizerMapper
    extends MapperBase {
        Record word;
        Record one;

        @Override
        public void setup(Mapper.TaskContext context) throws IOException {
            this.word = context.createMapOutputKeyRecord();
            this.one = context.createMapOutputValueRecord();
            this.one.setBigint(0, Long.valueOf(1L));
        }

        @Override
        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            for (int i = 0; i < record.getColumnCount(); ++i) {
                String[] words;
                for (String w : words = record.get(i).toString().split("\\s+")) {
                    this.word.setString(0, w);
                    context.write(this.word, this.one);
                }
            }
        }
    }
}

