/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.example;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import java.io.IOException;
import java.util.Iterator;

public class WordCount {
    public static void main(String[] args) throws OdpsException {
        if (args.length != 2) {
            System.err.println("Usage: wordcount <in_table> <out_table>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(TokenizerMapper.class);
        job.setCombinerClass(SumCombiner.class);
        job.setReducerClass(SumReducer.class);
        job.setMapOutputKeySchema(new Column[]{new Column("word", OdpsType.STRING)});
        job.setMapOutputValueSchema(new Column[]{new Column("count", OdpsType.BIGINT)});
        InputUtils.addTable(TableInfo.builder().tableName(args[0]).build(), job);
        OutputUtils.addTable(TableInfo.builder().tableName(args[1]).build(), job);
        JobClient.runJob(job);
    }

    public static class SumReducer
    extends ReducerBase {
        private Record result;

        @Override
        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        @Override
        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            this.result.set(0, key.get(0));
            this.result.set(1, (Object)count);
            context.write(this.result);
        }
    }

    public static class SumCombiner
    extends ReducerBase {
        private Record count;

        @Override
        public void setup(Reducer.TaskContext context) throws IOException {
            this.count = context.createMapOutputValueRecord();
        }

        @Override
        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long c = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                c += ((Long)val.get(0)).longValue();
            }
            this.count.set(0, (Object)c);
            context.write(key, this.count);
        }
    }

    public static class TokenizerMapper
    extends MapperBase {
        Record word;
        Record one;

        @Override
        public void setup(Mapper.TaskContext context) throws IOException {
            this.word = context.createMapOutputKeyRecord();
            this.one = context.createMapOutputValueRecord();
            this.one.setBigint(0, Long.valueOf(1L));
        }

        @Override
        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            for (int i = 0; i < record.getColumnCount(); ++i) {
                String[] words;
                for (String w : words = record.get(i).toString().split("\\s+")) {
                    this.word.setString(0, w);
                    context.write(this.word, this.one);
                }
            }
        }
    }
}

