/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.example;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.example.WordCount;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WordCountWithMultiInsert {
    public static void main(String[] args) throws OdpsException {
        if (args.length != 2) {
            System.err.println("Usage: wordcount <in_table> <out_table>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(WordCount.TokenizerMapper.class);
        job.setCombinerClass(SumReducer.class);
        job.setReducerClass(SumReducer.class);
        job.setMapOutputKeySchema(new Column[]{new Column("word", OdpsType.STRING)});
        job.setMapOutputValueSchema(new Column[]{new Column("count", OdpsType.BIGINT)});
        InputUtils.addTable(TableInfo.builder().tableName(args[0]).build(), job);
        for (int i = 1; i < args.length; ++i) {
            OutputUtils.addTable(TableInfo.builder().tableName(args[i]).label(String.format("out%d", i)).build(), job);
        }
        JobClient.runJob(job);
    }

    public static class SumReducer
    extends ReducerBase {
        private Map<String, Record> result;

        @Override
        public void setup(Reducer.TaskContext context) throws IOException {
            TableInfo[] tbls = context.getOutputTableInfo();
            this.result = new HashMap<String, Record>();
            for (TableInfo tbl : tbls) {
                String lable = tbl.getLabel();
                this.result.put(lable, context.createOutputRecord(lable));
            }
        }

        @Override
        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            for (String label : this.result.keySet()) {
                Record r = this.result.get(label);
                r.set(0, key.get(0));
                r.set(1, (Object)count);
                context.write(r, label);
            }
        }
    }
}

