/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyServerConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.ProtocolHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy.Http2ProxyBackendHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy.Http2ProxyFrontendHandler;
import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;

public class Http2ProtocolProxyHandler
implements ProtocolHandler {
    private static final int PRI_INT = 1347569952;
    private final NettyServerConfig nettyServerConfig;

    public Http2ProtocolProxyHandler(NettyServerConfig nettyServerConfig) {
        this.nettyServerConfig = nettyServerConfig;
    }

    @Override
    public boolean match(ByteBuf in) {
        if (!this.nettyServerConfig.isEnableHttp2Proxy()) {
            return false;
        }
        return in.getInt(in.readerIndex()) == 1347569952;
    }

    @Override
    public void config(ChannelHandlerContext ctx, final ByteBuf msg) {
        final Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group(inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler(new Http2ProxyBackendHandler(inboundChannel))).option(ChannelOption.AUTO_READ, false);
        ChannelFuture f = b.connect(this.nettyServerConfig.getHttp2ProxyHost(), this.nettyServerConfig.getHttp2ProxyPort());
        final Channel outboundChannel = f.channel();
        ctx.pipeline().addLast(new Http2ProxyFrontendHandler(outboundChannel));
        msg.retain();
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    outboundChannel.writeAndFlush(msg);
                    inboundChannel.read();
                } else {
                    inboundChannel.close();
                }
            }
        });
    }
}

