/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.io.RepeatableFileInputStream;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CRC64;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.common.utils.RangeSpec;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressInputStream;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.internal.OSSCallbackErrorResponseHandler;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateSymlinkRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.HeadObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSSymlink;
import com.aliyun.oss.model.ObjectAcl;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.SetObjectAclRequest;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CheckedInputStream;

public class OSSObjectOperation
extends OSSOperation {
    public OSSObjectOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(putObjectRequest, "putObjectRequest");
        PutObjectResult result = null;
        result = putObjectRequest.getCallback() == null ? this.writeObjectInternal(WriteMode.OVERWRITE, putObjectRequest, ResponseParsers.putObjectReponseParser) : this.writeObjectInternal(WriteMode.OVERWRITE, putObjectRequest, ResponseParsers.putObjectCallbackReponseParser);
        if (this.isCrcCheckEnabled()) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public PutObjectResult putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders, boolean useChunkEncoding) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(signedUrl, "signedUrl");
        CodingUtils.assertParameterNotNull(requestContent, "requestContent");
        if (requestHeaders == null) {
            requestHeaders = new HashMap<String, String>();
        }
        RequestMessage request = new RequestMessage();
        request.setMethod(HttpMethod.PUT);
        request.setAbsoluteUrl(signedUrl);
        request.setUseUrlSignature(true);
        request.setContent(requestContent);
        request.setContentLength(OSSUtils.determineInputStreamLength(requestContent, contentLength, useChunkEncoding));
        request.setHeaders(requestHeaders);
        request.setUseChunkEncoding(useChunkEncoding);
        PutObjectResult result = null;
        result = requestHeaders.get("x-oss-callback") == null ? this.doOperation(request, ResponseParsers.putObjectReponseParser, null, null, true) : this.doOperation(request, ResponseParsers.putObjectCallbackReponseParser, null, null, true);
        if (this.isCrcCheckEnabled()) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public AppendObjectResult appendObject(AppendObjectRequest appendObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(appendObjectRequest, "appendObjectRequest");
        AppendObjectResult result = this.writeObjectInternal(WriteMode.APPEND, appendObjectRequest, ResponseParsers.appendObjectResponseParser);
        if (appendObjectRequest.getInitCRC() != null && result.getClientCRC() != null) {
            result.setClientCRC(CRC64.combine(appendObjectRequest.getInitCRC(), result.getClientCRC(), result.getNextPosition() - appendObjectRequest.getPosition()));
        }
        if (this.isCrcCheckEnabled() && appendObjectRequest.getInitCRC() != null) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public OSSObject getObject(GetObjectRequest getObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
        String bucketName = null;
        String key = null;
        RequestMessage request = null;
        if (!getObjectRequest.isUseUrlSignature()) {
            CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
            bucketName = getObjectRequest.getBucketName();
            key = getObjectRequest.getKey();
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            CodingUtils.assertParameterNotNull(key, "key");
            OSSUtils.ensureBucketNameValid(bucketName);
            OSSUtils.ensureObjectKeyValid(key);
            HashMap<String, String> headers = new HashMap<String, String>();
            OSSObjectOperation.populateGetObjectRequestHeaders(getObjectRequest, headers);
            HashMap<String, String> params = new HashMap<String, String>();
            OSSUtils.populateResponseHeaderParameters(params, getObjectRequest.getResponseHeaders());
            String process = getObjectRequest.getProcess();
            if (process != null) {
                params.put("x-oss-process", process);
            }
            request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(getObjectRequest).build();
        } else {
            request = new RequestMessage(getObjectRequest);
            request.setMethod(HttpMethod.GET);
            request.setAbsoluteUrl(getObjectRequest.getAbsoluteUri());
            request.setUseUrlSignature(true);
            request.setHeaders(getObjectRequest.getHeaders());
        }
        ProgressListener listener = getObjectRequest.getProgressListener();
        OSSObject ossObject = null;
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            ossObject = this.doOperation(request, new ResponseParsers.GetObjectResponseParser(bucketName, key), bucketName, key, true);
            InputStream instream = ossObject.getObjectContent();
            ProgressInputStream progressInputStream = new ProgressInputStream(instream, listener){

                @Override
                protected void onEOF() {
                    ProgressPublisher.publishProgress(this.getListener(), ProgressEventType.TRANSFER_COMPLETED_EVENT);
                }
            };
            CRC64 crc = new CRC64();
            CheckedInputStream checkedInputstream = new CheckedInputStream(progressInputStream, crc);
            ossObject.setObjectContent(checkedInputstream);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
        return ossObject;
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) throws OSSException, ClientException {
        ObjectMetadata objectMetadata;
        CodingUtils.assertParameterNotNull(file, "file");
        OSSObject ossObject = this.getObject(getObjectRequest);
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            if (this.isCrcCheckEnabled() && !this.hasRangeInRequest(getObjectRequest)) {
                Long clientCRC = IOUtils.getCRCValue(ossObject.getObjectContent());
                OSSUtils.checkChecksum(clientCRC, ossObject.getServerCRC(), ossObject.getRequestId());
            }
            objectMetadata = ossObject.getObjectMetadata();
        }
        catch (IOException ex) {
            try {
                LogUtils.logException("Cannot read object content stream: ", ex);
                throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), ex);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(ossObject.getObjectContent());
                throw throwable;
            }
        }
        IOUtils.safeClose(outputStream);
        IOUtils.safeClose(ossObject.getObjectContent());
        return objectMetadata;
    }

    public SimplifiedObjectMeta getSimplifiedObjectMeta(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectMeta", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getSimplifiedObjectMetaResponseParser, bucketName, key, true);
    }

    public ObjectMetadata getObjectMetadata(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).setOriginalRequest(genericRequest).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new ResponseHandler(){

            @Override
            public void handle(ResponseMessage response) throws ServiceException, ClientException {
                if (response.getStatusCode() == 404) {
                    OSSUtils.safeCloseResponse(response);
                    throw ExceptionFactory.createOSSException(response.getHeaders().get("x-oss-request-id"), "NoSuchKey", OSSUtils.OSS_RESOURCE_MANAGER.getString("NoSuchKey"));
                }
            }
        });
        return this.doOperation(request, ResponseParsers.getObjectMetadataResponseParser, bucketName, key, true, null, reponseHandlers);
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(copyObjectRequest, "copyObjectRequest");
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateCopyObjectHeaders(copyObjectRequest, headers);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(copyObjectRequest.getDestinationBucketName()).setKey(copyObjectRequest.getDestinationKey()).setHeaders(headers).setOriginalRequest(copyObjectRequest).build();
        return this.doOperation(request, ResponseParsers.copyObjectResponseParser, copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey(), true);
    }

    public void deleteObject(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        CodingUtils.assertParameterNotNull(deleteObjectsRequest, "deleteObjectsRequest");
        String bucketName = deleteObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delete", null);
        byte[] rawContent = RequestMarshallers.deleteObjectsRequestMarshaller.marshall(deleteObjectsRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.addDeleteObjectsRequiredHeaders(headers, rawContent);
        OSSObjectOperation.addDeleteObjectsOptionalHeaders(headers, deleteObjectsRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteObjectsRequest).build();
        return this.doOperation(request, ResponseParsers.deleteObjectsResponseParser, bucketName, null, true);
    }

    public void headObject(HeadObjectRequest headObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(headObjectRequest, "headObjectRequest");
        String bucketName = headObjectRequest.getBucketName();
        String key = headObjectRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.addDateHeader(headers, "If-Modified-Since", headObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "If-Unmodified-Since", headObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "If-Match", headObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "If-None-Match", headObjectRequest.getNonmatchingETagConstraints());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).setHeaders(headers).setOriginalRequest(headObjectRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setObjectAclRequest, "setObjectAclRequest");
        String bucketName = setObjectAclRequest.getBucketName();
        String key = setObjectAclRequest.getKey();
        CannedAccessControlList cannedAcl = setObjectAclRequest.getCannedACL();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertParameterNotNull((Object)cannedAcl, "cannedAcl");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-object-acl", cannedAcl.toString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setParameters(params).setHeaders(headers).setOriginalRequest(setObjectAclRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public ObjectAcl getObjectAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getObjectAclResponseParser, bucketName, key, true);
    }

    public OSSSymlink getSymlink(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String symlink = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(symlink, "symlink");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(symlink);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("symlink", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(symlink).setParameters(params).setOriginalRequest(genericRequest).build();
        OSSSymlink symbolicLink = this.doOperation(request, ResponseParsers.getSymbolicLinkResponseParser, bucketName, symlink, true);
        if (symbolicLink != null) {
            symbolicLink.setSymlink(new String(symlink));
        }
        return symbolicLink;
    }

    public void createSymlink(CreateSymlinkRequest createSymlinkRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createSymlinkRequest, "createSymlinkRequest");
        String bucketName = createSymlinkRequest.getBucketName();
        String symlink = createSymlinkRequest.getSymlink();
        String target = createSymlinkRequest.getTarget();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(symlink, "symlink");
        CodingUtils.assertParameterNotNull(target, "target");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(symlink);
        OSSUtils.ensureObjectKeyValid(target);
        HashMap<String, String> headers = new HashMap<String, String>();
        String encodeTargetObject = HttpUtil.urlEncode(target, "utf-8");
        headers.put("x-oss-symlink-target", encodeTargetObject);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("symlink", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(symlink).setHeaders(headers).setParameters(params).setOriginalRequest(createSymlinkRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, symlink);
    }

    private <RequestType extends PutObjectRequest, ResponseType> ResponseType writeObjectInternal(WriteMode mode, RequestType originalRequest, ResponseParser<ResponseType> responseParser) {
        String bucketName = originalRequest.getBucketName();
        String key = originalRequest.getKey();
        InputStream originalInputStream = originalRequest.getInputStream();
        ObjectMetadata metadata = originalRequest.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        OSSUtils.ensureCallbackValid(originalRequest.getCallback());
        InputStream repeatableInputStream = null;
        if (originalRequest.getFile() != null) {
            File toUpload = originalRequest.getFile();
            if (!IOUtils.checkFile(toUpload)) {
                LogUtils.getLog().info((Object)("Illegal file path: " + toUpload.getPath()));
                throw new ClientException("Illegal file path: " + toUpload.getPath());
            }
            metadata.setContentLength(toUpload.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(toUpload));
            }
            try {
                repeatableInputStream = new RepeatableFileInputStream(toUpload);
            }
            catch (IOException ex) {
                LogUtils.logException("Cannot locate file to upload: ", ex);
                throw new ClientException("Cannot locate file to upload: ", ex);
            }
        }
        CodingUtils.assertTrue(originalInputStream != null, "Please specify input stream or file to upload");
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(key));
        }
        try {
            repeatableInputStream = IOUtils.newRepeatableInputStream(originalInputStream);
        }
        catch (IOException ex) {
            LogUtils.logException("Cannot wrap to repeatable input stream: ", ex);
            throw new ClientException("Cannot wrap to repeatable input stream: ", ex);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.populateRequestMetadata(headers, metadata);
        OSSUtils.populateRequestCallback(headers, originalRequest.getCallback());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSObjectOperation.populateWriteObjectParams(mode, originalRequest, params);
        RequestMessage httpRequest = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(WriteMode.getMappingMethod(mode)).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputStream(repeatableInputStream).setInputSize(OSSUtils.determineInputStreamLength(repeatableInputStream, metadata.getContentLength())).setOriginalRequest(originalRequest).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new OSSCallbackErrorResponseHandler());
        ProgressListener listener = originalRequest.getProgressListener();
        ResponseType result = null;
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            result = originalRequest.getCallback() == null ? (ResponseType)this.doOperation(httpRequest, responseParser, bucketName, key, true) : (ResponseType)this.doOperation(httpRequest, responseParser, bucketName, key, true, null, reponseHandlers);
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
        return result;
    }

    private boolean isCrcCheckEnabled() {
        return this.getInnerClient().getClientConfiguration().isCrcCheckEnabled();
    }

    private boolean hasRangeInRequest(GetObjectRequest getObjectRequest) {
        return getObjectRequest.getHeaders().get("Range") != null;
    }

    private static void populateCopyObjectHeaders(CopyObjectRequest copyObjectRequest, Map<String, String> headers) {
        String copySourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(copyObjectRequest.getSourceKey(), "utf-8");
        headers.put("x-oss-copy-source", copySourceHeader);
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", copyObjectRequest.getNonmatchingEtagConstraints());
        OSSUtils.addHeader(headers, "x-oss-server-side-encryption", copyObjectRequest.getServerSideEncryption());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            headers.put("x-oss-metadata-directive", MetadataDirective.REPLACE.toString());
            OSSUtils.populateRequestMetadata(headers, newObjectMetadata);
        }
        OSSUtils.removeHeader(headers, "Content-Length");
    }

    private static void populateGetObjectRequestHeaders(GetObjectRequest getObjectRequest, Map<String, String> headers) {
        if (getObjectRequest.getRange() != null) {
            OSSObjectOperation.addGetObjectRangeHeader(getObjectRequest.getRange(), headers);
        }
        if (getObjectRequest.getModifiedSinceConstraint() != null) {
            headers.put("If-Modified-Since", DateUtil.formatRfc822Date(getObjectRequest.getModifiedSinceConstraint()));
        }
        if (getObjectRequest.getUnmodifiedSinceConstraint() != null) {
            headers.put("If-Unmodified-Since", DateUtil.formatRfc822Date(getObjectRequest.getUnmodifiedSinceConstraint()));
        }
        if (getObjectRequest.getMatchingETagConstraints().size() > 0) {
            headers.put("If-Match", OSSUtils.joinETags(getObjectRequest.getMatchingETagConstraints()));
        }
        if (getObjectRequest.getNonmatchingETagConstraints().size() > 0) {
            headers.put("If-None-Match", OSSUtils.joinETags(getObjectRequest.getNonmatchingETagConstraints()));
        }
    }

    private static void addDeleteObjectsRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        headers.put("Content-Length", String.valueOf(rawContent.length));
        byte[] md5 = BinaryUtil.calculateMd5(rawContent);
        String md5Base64 = BinaryUtil.toBase64String(md5);
        headers.put("Content-MD5", md5Base64);
    }

    private static void addDeleteObjectsOptionalHeaders(Map<String, String> headers, DeleteObjectsRequest request) {
        if (request.getEncodingType() != null) {
            headers.put("encoding-type", request.getEncodingType());
        }
    }

    private static void addGetObjectRangeHeader(long[] range, Map<String, String> headers) {
        RangeSpec rangeSpec = RangeSpec.parse(range);
        headers.put("Range", rangeSpec.toString());
    }

    private static void populateWriteObjectParams(WriteMode mode, PutObjectRequest originalRequest, Map<String, String> params) {
        if (mode == WriteMode.OVERWRITE) {
            return;
        }
        assert (originalRequest instanceof AppendObjectRequest);
        params.put("append", null);
        AppendObjectRequest appendObjectRequest = (AppendObjectRequest)originalRequest;
        if (appendObjectRequest.getPosition() != null) {
            params.put("position", String.valueOf(appendObjectRequest.getPosition()));
        }
    }

    private static enum WriteMode {
        APPEND("APPEND"),
        OVERWRITE("OVERWRITE");

        private final String modeAsString;

        private WriteMode(String modeAsString) {
            this.modeAsString = modeAsString;
        }

        public String toString() {
            return this.modeAsString;
        }

        public static HttpMethod getMappingMethod(WriteMode mode) {
            switch (mode) {
                case APPEND: {
                    return HttpMethod.POST;
                }
                case OVERWRITE: {
                    return HttpMethod.PUT;
                }
            }
            throw new IllegalArgumentException("Unsuported write mode" + mode.toString());
        }
    }

    private static enum MetadataDirective {
        COPY("COPY"),
        REPLACE("REPLACE");

        private final String directiveAsString;

        private MetadataDirective(String directiveAsString) {
            this.directiveAsString = directiveAsString;
        }

        public String toString() {
            return this.directiveAsString;
        }
    }
}

