/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.StandardHugeGraph;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.task.TaskManager;
import com.baidu.hugegraph.traversal.algorithm.OltpTraverser;
import com.baidu.hugegraph.type.define.SerialEnum;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;

public class HugeFactory {
    private static final Logger LOG = Log.logger(HugeGraph.class);
    private static final String NAME_REGEX = "^[A-Za-z][A-Za-z0-9_]{0,47}$";
    private static final Map<String, HugeGraph> graphs;

    public static synchronized HugeGraph open(Configuration config) {
        HugeConfig conf = config instanceof HugeConfig ? (HugeConfig)config : new HugeConfig(config);
        return HugeFactory.open(conf);
    }

    public static synchronized HugeGraph open(HugeConfig config) {
        String name = (String)config.get(CoreOptions.STORE);
        HugeFactory.checkGraphName(name, "graph config(like hugegraph.properties)");
        name = name.toLowerCase();
        HugeGraph graph = graphs.get(name);
        if (graph == null || graph.closed()) {
            graph = new StandardHugeGraph(config);
            graphs.put(name, graph);
        } else {
            String backend = (String)config.get(CoreOptions.BACKEND);
            E.checkState((boolean)backend.equalsIgnoreCase(graph.backend()), (String)"Graph name '%s' has been used by backend '%s'", (Object[])new Object[]{name, graph.backend()});
        }
        return graph;
    }

    public static HugeGraph open(String path) {
        return HugeFactory.open((Configuration)HugeFactory.getLocalConfig(path));
    }

    public static HugeGraph open(URL url) {
        return HugeFactory.open((Configuration)HugeFactory.getRemoteConfig(url));
    }

    public static void checkGraphName(String name, String configFile) {
        E.checkArgument((boolean)name.matches(NAME_REGEX), (String)"Invalid graph name '%s' in %s, valid graph name is up to 48 alpha-numeric characters and underscores and only letters are supported as first letter. Note: letter is case insensitive", (Object[])new Object[]{name, configFile});
    }

    public static PropertiesConfiguration getLocalConfig(String path) {
        File file = new File(path);
        E.checkArgument((file.exists() && file.isFile() && file.canRead() ? 1 : 0) != 0, (String)"Please specify a proper config file rather than: %s", (Object[])new Object[]{file.toString()});
        try {
            return new PropertiesConfiguration(file);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Unable to load config file: %s", (Throwable)e, path);
        }
    }

    public static PropertiesConfiguration getRemoteConfig(URL url) {
        try {
            return new PropertiesConfiguration(url);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Unable to load remote config file: %s", (Throwable)e, url);
        }
    }

    public static void shutdown(long timeout) {
        try {
            if (!EventHub.destroy((long)timeout)) {
                throw new TimeoutException(timeout + "s");
            }
            TaskManager.instance().shutdown(timeout);
            OltpTraverser.destroy();
        }
        catch (Throwable e) {
            LOG.error("Error while shutdown", e);
            throw new HugeException("Failed to shutdown", e);
        }
    }

    static {
        SerialEnum.registerInternalEnums();
        HugeGraph.registerTraversalStrategies(StandardHugeGraph.class);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("HugeGraph is shutting down");
            HugeFactory.shutdown(30L);
        }));
        graphs = new HashMap<String, HugeGraph>();
    }
}

