/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph;

import com.baidu.hugegraph.auth.UserManager;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendFeatures;
import com.baidu.hugegraph.backend.store.BackendStoreSystemInfo;
import com.baidu.hugegraph.backend.store.raft.RaftGroupManager;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.SchemaManager;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeFeatures;
import com.baidu.hugegraph.task.TaskScheduler;
import com.baidu.hugegraph.traversal.optimize.HugeCountStepStrategy;
import com.baidu.hugegraph.traversal.optimize.HugeGraphStepStrategy;
import com.baidu.hugegraph.traversal.optimize.HugeVertexStepStrategy;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.GraphMode;
import com.baidu.hugegraph.type.define.NodeRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public interface HugeGraph
extends Graph {
    public HugeGraph hugegraph();

    public SchemaManager schema();

    public Id getNextId(HugeType var1);

    public void addPropertyKey(PropertyKey var1);

    public void removePropertyKey(Id var1);

    public Collection<PropertyKey> propertyKeys();

    public PropertyKey propertyKey(String var1);

    public PropertyKey propertyKey(Id var1);

    public boolean existsPropertyKey(String var1);

    public void addVertexLabel(VertexLabel var1);

    public Id removeVertexLabel(Id var1);

    public Collection<VertexLabel> vertexLabels();

    public VertexLabel vertexLabel(String var1);

    public VertexLabel vertexLabel(Id var1);

    public VertexLabel vertexLabelOrNone(Id var1);

    public boolean existsVertexLabel(String var1);

    public boolean existsLinkLabel(Id var1);

    public void addEdgeLabel(EdgeLabel var1);

    public Id removeEdgeLabel(Id var1);

    public Collection<EdgeLabel> edgeLabels();

    public EdgeLabel edgeLabel(String var1);

    public EdgeLabel edgeLabel(Id var1);

    public EdgeLabel edgeLabelOrNone(Id var1);

    public boolean existsEdgeLabel(String var1);

    public void addIndexLabel(SchemaLabel var1, IndexLabel var2);

    public Id removeIndexLabel(Id var1);

    public Id rebuildIndex(SchemaElement var1);

    public Collection<IndexLabel> indexLabels();

    public IndexLabel indexLabel(String var1);

    public IndexLabel indexLabel(Id var1);

    public boolean existsIndexLabel(String var1);

    public Vertex addVertex(Object ... var1);

    public void removeVertex(Vertex var1);

    public void removeVertex(String var1, Object var2);

    public <V> void addVertexProperty(VertexProperty<V> var1);

    public <V> void removeVertexProperty(VertexProperty<V> var1);

    public Edge addEdge(Edge var1);

    public void canAddEdge(Edge var1);

    public void removeEdge(Edge var1);

    public void removeEdge(String var1, Object var2);

    public <V> void addEdgeProperty(Property<V> var1);

    public <V> void removeEdgeProperty(Property<V> var1);

    public Vertex vertex(Object var1);

    public Iterator<Vertex> vertices(Object ... var1);

    public Iterator<Vertex> vertices(Query var1);

    public Iterator<Vertex> adjacentVertex(Object var1);

    public boolean checkAdjacentVertexExist();

    public Edge edge(Object var1);

    public Iterator<Edge> edges(Object ... var1);

    public Iterator<Edge> edges(Query var1);

    public Iterator<Vertex> adjacentVertices(Iterator<Edge> var1);

    public Iterator<Edge> adjacentEdges(Id var1);

    public Number queryNumber(Query var1);

    public String name();

    public String backend();

    public String backendVersion();

    public BackendStoreSystemInfo backendStoreSystemInfo();

    public BackendFeatures backendStoreFeatures();

    public GraphMode mode();

    public void mode(GraphMode var1);

    public void waitStarted();

    public void serverStarted(Id var1, NodeRole var2);

    public boolean started();

    public boolean closed();

    public <T> T metadata(HugeType var1, String var2, Object ... var3);

    public void initBackend();

    public void clearBackend();

    public void truncateBackend();

    public HugeFeatures features();

    public UserManager userManager();

    public TaskScheduler taskScheduler();

    public RaftGroupManager raftGroupManager(String var1);

    public void proxy(HugeGraph var1);

    public boolean sameAs(HugeGraph var1);

    public long now();

    default public List<String> mapPkId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            PropertyKey schema = this.propertyKey(id);
            names.add(schema.name());
        }
        return names;
    }

    default public List<String> mapVlId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            VertexLabel schema = this.vertexLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    default public List<String> mapElId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            EdgeLabel schema = this.edgeLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    default public List<String> mapIlId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            IndexLabel schema = this.indexLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    default public List<Id> mapPkName2Id(Collection<String> pkeys) {
        ArrayList<Id> ids = new ArrayList<Id>(pkeys.size());
        for (String pkey : pkeys) {
            PropertyKey propertyKey = this.propertyKey(pkey);
            ids.add(propertyKey.id());
        }
        return ids;
    }

    default public Id[] mapElName2Id(String[] edgeLabels) {
        Id[] ids = new Id[edgeLabels.length];
        for (int i = 0; i < edgeLabels.length; ++i) {
            EdgeLabel edgeLabel = this.edgeLabel(edgeLabels[i]);
            ids[i] = edgeLabel.id();
        }
        return ids;
    }

    default public Id[] mapVlName2Id(String[] vertexLabels) {
        Id[] ids = new Id[vertexLabels.length];
        for (int i = 0; i < vertexLabels.length; ++i) {
            VertexLabel vertexLabel = this.vertexLabel(vertexLabels[i]);
            ids[i] = vertexLabel.id();
        }
        return ids;
    }

    public static void registerTraversalStrategies(Class<?> clazz) {
        TraversalStrategies strategies = null;
        strategies = TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone();
        strategies.addStrategies(new TraversalStrategy[]{HugeVertexStepStrategy.instance(), HugeGraphStepStrategy.instance(), HugeCountStepStrategy.instance()});
        TraversalStrategies.GlobalCache.registerStrategies(clazz, (TraversalStrategies)strategies);
    }
}

