/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.auth.SchemaDefine;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.iterator.MapperIterator;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class EntityManager<T extends SchemaDefine.Entity> {
    private final HugeGraphParams graph;
    private final String label;
    private final Function<Vertex, T> deser;
    private static final long NO_LIMIT = -1L;

    public EntityManager(HugeGraphParams graph, String label, Function<Vertex, T> dser) {
        E.checkNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        this.label = label;
        this.deser = dser;
    }

    private GraphTransaction tx() {
        return this.graph.systemTransaction();
    }

    private HugeGraph graph() {
        return this.graph.graph();
    }

    private String unhideLabel() {
        return Graph.Hidden.unHide((String)this.label);
    }

    public Id add(T entity) {
        E.checkArgumentNotNull(entity, (String)"Entity can't be null", (Object[])new Object[0]);
        return this.save(entity, false);
    }

    public Id update(T entity) {
        E.checkArgumentNotNull(entity, (String)"Entity can't be null", (Object[])new Object[0]);
        ((SchemaDefine.UserElement)entity).onUpdate();
        return this.save(entity, true);
    }

    public T delete(Id id) {
        SchemaDefine.Entity entity = null;
        Iterator<Vertex> vertices = this.tx().queryVertices(id);
        if (vertices.hasNext()) {
            HugeVertex vertex = (HugeVertex)vertices.next();
            entity = (SchemaDefine.Entity)this.deser.apply(vertex);
            this.tx().removeVertex(vertex);
            this.commitOrRollback();
            assert (!vertices.hasNext());
        }
        return (T)entity;
    }

    public T get(Id id) {
        SchemaDefine.Entity entity = null;
        Iterator<Vertex> vertices = this.tx().queryVertices(id);
        if (vertices.hasNext()) {
            entity = (SchemaDefine.Entity)this.deser.apply(vertices.next());
            assert (!vertices.hasNext());
        }
        if (entity == null) {
            throw new NotFoundException("Can't find %s with id '%s'", this.unhideLabel(), id);
        }
        return (T)entity;
    }

    public boolean exists(Id id) {
        Vertex vertex;
        Iterator<Vertex> vertices = this.tx().queryVertices(id);
        return vertices.hasNext() && this.label.equals((vertex = vertices.next()).label());
    }

    public List<T> list(List<Id> ids) {
        return this.toList(this.queryById(ids));
    }

    public List<T> list(long limit) {
        return this.toList(this.queryEntity(this.label, (Map<String, Object>)ImmutableMap.of(), limit));
    }

    protected List<T> query(String key, Object value, long limit) {
        ImmutableMap conditions = ImmutableMap.of((Object)key, (Object)value);
        return this.toList(this.queryEntity(this.label, (Map<String, Object>)conditions, limit));
    }

    protected List<T> toList(Iterator<Vertex> vertices) {
        MapperIterator iter = new MapperIterator(vertices, this.deser);
        return (List)QueryResults.toList(iter).list();
    }

    private Iterator<Vertex> queryById(List<Id> ids) {
        Object[] idArray = ids.toArray(new Id[ids.size()]);
        Iterator<Vertex> vertices = this.tx().queryVertices(idArray);
        return vertices;
    }

    private Iterator<Vertex> queryEntity(String label, Map<String, Object> conditions, long limit) {
        ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
        VertexLabel vl = this.graph().vertexLabel(label);
        query.eq(HugeKeys.LABEL, vl.id());
        for (Map.Entry<String, Object> entry : conditions.entrySet()) {
            PropertyKey pkey = this.graph().propertyKey(entry.getKey());
            query.query(Condition.eq(pkey.id(), entry.getValue()));
        }
        query.showHidden(true);
        if (limit != -1L) {
            query.limit(limit);
        }
        return this.tx().queryVertices(query);
    }

    private Id save(T entity, boolean expectExists) {
        HugeVertex vertex = this.constructVertex((SchemaDefine.Entity)entity);
        E.checkArgument((this.exists(vertex.id()) == expectExists ? 1 : 0) != 0, (String)"Can't save %s '%s' that %s exists", (Object[])new Object[]{this.unhideLabel(), vertex.id(), expectExists ? "not" : "already"});
        vertex = this.tx().addVertex(vertex);
        this.commitOrRollback();
        return vertex.id();
    }

    private HugeVertex constructVertex(SchemaDefine.Entity entity) {
        if (!this.graph().existsVertexLabel(entity.label())) {
            throw new HugeException("Schema is missing for %s '%s'", entity.label(), entity.id());
        }
        return this.tx().constructVertex(false, entity.asArray());
    }

    private void commitOrRollback() {
        this.tx().commitOrRollback();
    }
}

