/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.auth.HugeGroup;
import com.baidu.hugegraph.auth.HugeUser;
import com.baidu.hugegraph.auth.ResourceType;
import com.baidu.hugegraph.auth.SchemaDefine;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.schema.EdgeLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;

public class HugeBelong
extends SchemaDefine.Relationship {
    private final Id user;
    private final Id group;
    private String description;

    public HugeBelong(Id user, Id group) {
        this.user = user;
        this.group = group;
        this.description = null;
    }

    @Override
    public ResourceType type() {
        return ResourceType.GRANT;
    }

    @Override
    public String label() {
        return P.BELONG;
    }

    @Override
    public String sourceLabel() {
        return P.USER;
    }

    @Override
    public String targetLabel() {
        return P.GROUP;
    }

    @Override
    public Id source() {
        return this.user;
    }

    @Override
    public Id target() {
        return this.group;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("HugeBelong(%s->%s)%s", this.user, this.group, this.asMap());
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~belong_description": {
                this.description = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        ArrayList<Object> list = new ArrayList<Object>(10);
        list.add(T.label);
        list.add(P.BELONG);
        if (this.description != null) {
            list.add("~belong_description");
            list.add(this.description);
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)P.USER), this.user);
        map.put(Graph.Hidden.unHide((String)P.GROUP), this.group);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~belong_description"), this.description);
        }
        return super.asMap(map);
    }

    public static <V> HugeBelong fromEdge(Edge edge) {
        HugeBelong belong = new HugeBelong((Id)edge.outVertex().id(), (Id)edge.inVertex().id());
        return HugeBelong.fromEdge(edge, belong);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.BELONG);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existEdgeLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            EdgeLabel label = (EdgeLabel)this.schema().edgeLabel(this.label).sourceLabel(P.USER).targetLabel(P.GROUP).properties(properties).nullableKeys("~belong_description").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addEdgeLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~belong_description"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String BELONG = Graph.Hidden.hide((String)"belong");
        public static final String LABEL = T.label.getAccessor();
        public static final String USER = HugeUser.P.USER;
        public static final String GROUP = HugeGroup.P.GROUP;
        public static final String DESCRIPTION = "~belong_description";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"belong_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

