/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.auth.ResourceObject;
import com.baidu.hugegraph.auth.ResourceType;
import com.baidu.hugegraph.auth.SchemaDefine;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.traversal.optimize.TraversalUtil;
import com.baidu.hugegraph.type.Namifiable;
import com.baidu.hugegraph.type.Typifiable;
import com.baidu.hugegraph.util.JsonUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonProperty;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class HugeResource {
    public static final String ANY = "*";
    public static final HugeResource ALL = new HugeResource(ResourceType.ALL, "*", null);
    public static final List<HugeResource> ALL_RES = ImmutableList.of((Object)ALL);
    private static final Set<ResourceType> CHECK_NAME_RESS = ImmutableSet.of((Object)((Object)ResourceType.META));
    @JsonProperty(value="type")
    private ResourceType type = ResourceType.NONE;
    @JsonProperty(value="label")
    private String label = "*";
    @JsonProperty(value="properties")
    private Map<String, Object> properties;

    public HugeResource() {
    }

    public HugeResource(ResourceType type, String label, Map<String, Object> properties) {
        this.type = type;
        this.label = label;
        this.properties = properties;
        this.checkFormat();
    }

    public void checkFormat() {
        if (this.properties == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String propName = entry.getKey();
            Object propValue = entry.getValue();
            if (propName.equals(ANY) && propValue.equals(ANY) || !(propValue instanceof String) || !((String)propValue).startsWith("P.")) continue;
            TraversalUtil.parsePredicate((String)propValue);
        }
    }

    public boolean filter(ResourceObject<?> resourceObject) {
        if (this.type == null || this.type == ResourceType.NONE) {
            return false;
        }
        if (!this.type.match(resourceObject.type())) {
            return false;
        }
        if (resourceObject.operated() != NameObject.ANY) {
            ResourceType resType = resourceObject.type();
            if (resType.isGraph()) {
                return this.filter((HugeElement)resourceObject.operated());
            }
            if (resType.isUsers()) {
                return this.filter((SchemaDefine.UserElement)resourceObject.operated());
            }
            if (resType.isSchema() || CHECK_NAME_RESS.contains((Object)resType)) {
                return this.filter((Namifiable)resourceObject.operated());
            }
        }
        return true;
    }

    private boolean filter(SchemaDefine.UserElement element) {
        assert (this.type.match(element.type()));
        return !(element instanceof Namifiable) || this.filter((Namifiable)((Object)element));
    }

    private boolean filter(Namifiable element) {
        assert (!(element instanceof Typifiable) || this.type.match(ResourceType.from(((Typifiable)((Object)element)).type())));
        return this.matchLabel(element.name());
    }

    private boolean filter(HugeElement element) {
        assert (this.type.match(ResourceType.from(element.type())));
        if (!this.matchLabel(element.label())) {
            return false;
        }
        if (this.properties == null) {
            return true;
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String propName = entry.getKey();
            Object expected = entry.getValue();
            if (propName.equals(ANY) && expected.equals(ANY)) {
                return true;
            }
            Property prop = element.property(propName);
            if (!prop.isPresent()) {
                return false;
            }
            try {
                if (TraversalUtil.testProperty(prop, expected)) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                throw new HugeException("Invalid resouce '%s' for '%s': %s", expected, propName, e.getMessage());
            }
        }
        return true;
    }

    private boolean matchLabel(String other) {
        if (this.label == null || other == null) {
            return false;
        }
        return this.label.equals(ANY) || other.matches(this.label);
    }

    private boolean matchProperties(Map<String, Object> other) {
        if (this.properties == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        for (Map.Entry<String, Object> p : other.entrySet()) {
            Object value = this.properties.get(p.getKey());
            if (Objects.equals(value, p.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean contains(HugeResource other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.type == null || this.type == ResourceType.NONE) {
            return false;
        }
        if (!this.type.match(other.type)) {
            return false;
        }
        if (!this.matchLabel(other.label)) {
            return false;
        }
        return this.matchProperties(other.properties);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HugeResource)) {
            return false;
        }
        HugeResource other = (HugeResource)object;
        return this.type == other.type && Objects.equals(this.label, other.label) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.label, this.properties});
    }

    public String toString() {
        return JsonUtil.toJson(this);
    }

    public static boolean allowed(ResourceObject<?> resourceObject) {
        Namifiable schema;
        return resourceObject.type().isSchema() && Graph.Hidden.isHidden((String)(schema = (Namifiable)resourceObject.operated()).name());
    }

    public static HugeResource parseResource(String resource) {
        return JsonUtil.fromJson(resource, HugeResource.class);
    }

    public static List<HugeResource> parseResources(String resources) {
        TypeReference<List<HugeResource>> type = new TypeReference<List<HugeResource>>(){};
        return (List)JsonUtil.fromJson(resources, type);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(HugeResource.class, (JsonSerializer)new HugeResourceSer());
        module.addDeserializer(HugeResource.class, (JsonDeserializer)new HugeResourceDeser());
        JsonUtil.registerModule((Module)module);
    }

    private static class HugeResourceDeser
    extends StdDeserializer<HugeResource> {
        private static final long serialVersionUID = -2499038590503066483L;

        public HugeResourceDeser() {
            super(HugeResource.class);
        }

        public HugeResource deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            HugeResource res = new HugeResource();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String key = parser.getCurrentName();
                if (key.equals("type")) {
                    if (parser.nextToken() != JsonToken.VALUE_NULL) {
                        res.type = (ResourceType)((Object)ctxt.readValue(parser, ResourceType.class));
                        continue;
                    }
                    res.type = null;
                    continue;
                }
                if (key.equals("label")) {
                    if (parser.nextToken() != JsonToken.VALUE_NULL) {
                        res.label = parser.getValueAsString();
                        continue;
                    }
                    res.label = null;
                    continue;
                }
                if (!key.equals("properties")) continue;
                if (parser.nextToken() != JsonToken.VALUE_NULL) {
                    Map prop = (Map)ctxt.readValue(parser, Map.class);
                    res.properties = prop;
                    continue;
                }
                res.properties = null;
            }
            res.checkFormat();
            return res;
        }
    }

    private static class HugeResourceSer
    extends StdSerializer<HugeResource> {
        private static final long serialVersionUID = -138482122210181714L;

        public HugeResourceSer() {
            super(HugeResource.class);
        }

        public void serialize(HugeResource res, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeObjectField("type", (Object)res.type);
            generator.writeObjectField("label", (Object)res.label);
            generator.writeObjectField("properties", (Object)res.properties);
            generator.writeEndObject();
        }
    }

    public static class NameObject
    implements Namifiable {
        public static final NameObject ANY = new NameObject("*");
        private final String name;

        public static NameObject of(String name) {
            return new NameObject(name);
        }

        private NameObject(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

