/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.auth.SchemaDefine;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.iterator.MapperIterator;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class RelationshipManager<T extends SchemaDefine.Relationship> {
    private final HugeGraphParams graph;
    private final String label;
    private final Function<Edge, T> deser;
    private static final long NO_LIMIT = -1L;

    public RelationshipManager(HugeGraphParams graph, String label, Function<Edge, T> dser) {
        E.checkNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        this.label = label;
        this.deser = dser;
    }

    private GraphTransaction tx() {
        return this.graph.systemTransaction();
    }

    private HugeGraph graph() {
        return this.graph.graph();
    }

    private String unhideLabel() {
        return Graph.Hidden.unHide((String)this.label);
    }

    public Id add(T relationship) {
        E.checkArgumentNotNull(relationship, (String)"Relationship can't be null", (Object[])new Object[0]);
        return this.save(relationship, false);
    }

    public Id update(T relationship) {
        E.checkArgumentNotNull(relationship, (String)"Relationship can't be null", (Object[])new Object[0]);
        ((SchemaDefine.UserElement)relationship).onUpdate();
        return this.save(relationship, true);
    }

    public T delete(Id id) {
        SchemaDefine.Relationship relationship = null;
        Iterator<Edge> edges = this.tx().queryEdges(id);
        if (edges.hasNext()) {
            HugeEdge edge = (HugeEdge)edges.next();
            relationship = (SchemaDefine.Relationship)this.deser.apply(edge);
            this.tx().removeEdge(edge);
            this.commitOrRollback();
            assert (!edges.hasNext());
        }
        return (T)relationship;
    }

    public T get(Id id) {
        SchemaDefine.Relationship relationship = null;
        Iterator<Edge> edges = this.tx().queryEdges(id);
        if (edges.hasNext()) {
            relationship = (SchemaDefine.Relationship)this.deser.apply(edges.next());
            assert (!edges.hasNext());
        }
        if (relationship == null) {
            throw new NotFoundException("Can't find %s with id '%s'", this.unhideLabel(), id);
        }
        return (T)relationship;
    }

    public boolean exists(Id id) {
        Edge edge;
        Iterator<Edge> edges = this.tx().queryEdges(id);
        return edges.hasNext() && this.label.equals((edge = edges.next()).label());
    }

    public List<T> list(List<Id> ids) {
        return this.toList(this.queryById(ids));
    }

    public List<T> list(long limit) {
        Iterator<Edge> edges = this.queryRelationship(null, null, this.label, (Map<String, Object>)ImmutableMap.of(), limit);
        return this.toList(edges);
    }

    public List<T> list(Id source, Directions direction, String label, long limit) {
        Iterator<Edge> edges = this.queryRelationship(source, direction, label, (Map<String, Object>)ImmutableMap.of(), limit);
        return this.toList(edges);
    }

    public List<T> list(Id source, Directions direction, String label, String key, Object value, long limit) {
        ImmutableMap conditions = ImmutableMap.of((Object)key, (Object)value);
        Iterator<Edge> edges = this.queryRelationship(source, direction, label, (Map<String, Object>)conditions, limit);
        return this.toList(edges);
    }

    protected List<T> toList(Iterator<Edge> edges) {
        MapperIterator iter = new MapperIterator(edges, this.deser);
        return (List)QueryResults.toList(iter).list();
    }

    private Iterator<Edge> queryById(List<Id> ids) {
        Object[] idArray = ids.toArray(new Id[ids.size()]);
        Iterator<Edge> edges = this.tx().queryEdges(idArray);
        return edges;
    }

    private Iterator<Edge> queryRelationship(Id source, Directions direction, String label, Map<String, Object> conditions, long limit) {
        ConditionQuery query = new ConditionQuery(HugeType.EDGE);
        EdgeLabel el = this.graph().edgeLabel(label);
        if (direction == null) {
            direction = Directions.OUT;
        }
        if (source != null) {
            query.eq(HugeKeys.OWNER_VERTEX, source);
            query.eq(HugeKeys.DIRECTION, direction);
        }
        if (label != null) {
            query.eq(HugeKeys.LABEL, el.id());
        }
        for (Map.Entry<String, Object> entry : conditions.entrySet()) {
            PropertyKey pk = this.graph().propertyKey(entry.getKey());
            query.query(Condition.eq(pk.id(), entry.getValue()));
        }
        query.showHidden(true);
        if (limit != -1L) {
            query.limit(limit);
        }
        Iterator<Edge> edges = this.tx().queryEdges(query);
        if (limit == -1L) {
            return edges;
        }
        long[] size = new long[1];
        return new MapperIterator(edges, edge -> {
            size[0] = size[0] + 1L;
            if (size[0] > limit) {
                return null;
            }
            return edge;
        });
    }

    private Id save(T relationship, boolean expectExists) {
        if (!this.graph().existsEdgeLabel(((SchemaDefine.UserElement)relationship).label())) {
            throw new HugeException("Schema is missing for %s '%s'", ((SchemaDefine.UserElement)relationship).label(), ((SchemaDefine.Relationship)relationship).source());
        }
        HugeVertex source = this.newVertex(((SchemaDefine.Relationship)relationship).source(), ((SchemaDefine.Relationship)relationship).sourceLabel());
        HugeVertex target = this.newVertex(((SchemaDefine.Relationship)relationship).target(), ((SchemaDefine.Relationship)relationship).targetLabel());
        HugeEdge edge = source.constructEdge(((SchemaDefine.UserElement)relationship).label(), target, ((SchemaDefine.UserElement)relationship).asArray());
        E.checkArgument((this.exists(edge.id()) == expectExists ? 1 : 0) != 0, (String)"Can't save %s '%s' that %s exists", (Object[])new Object[]{this.unhideLabel(), edge.id(), expectExists ? "not" : "already"});
        this.tx().addEdge(edge);
        this.commitOrRollback();
        return edge.id();
    }

    private HugeVertex newVertex(Object id, String label) {
        VertexLabel vl = this.graph().vertexLabel(label);
        Id idValue = HugeVertex.getIdValue(id);
        return HugeVertex.create(this.tx(), idValue, vl);
    }

    private void commitOrRollback() {
        this.tx().commitOrRollback();
    }
}

