/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.auth.ResourceType;
import com.baidu.hugegraph.auth.SchemaDefine;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.Namifiable;
import com.baidu.hugegraph.util.E;

public class ResourceObject<V> {
    private final String graph;
    private final ResourceType type;
    private final V operated;

    public ResourceObject(String graph, ResourceType type, V operated) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)((Object)type), (String)"type");
        E.checkNotNull(operated, (String)"operated");
        this.graph = graph;
        this.type = type;
        this.operated = operated;
    }

    public String graph() {
        return this.graph;
    }

    public ResourceType type() {
        return this.type;
    }

    public V operated() {
        return this.operated;
    }

    public String toString() {
        Object operated = this.operated;
        if (this.type.isUsers()) {
            operated = ((SchemaDefine.UserElement)this.operated).idString();
        }
        return String.format("Resource{graph=%s,type=%s,operated=%s}", new Object[]{this.graph, this.type, operated});
    }

    public static ResourceObject<SchemaElement> of(String graph, SchemaElement elem) {
        ResourceType resType = ResourceType.from(elem.type());
        return new ResourceObject<SchemaElement>(graph, resType, elem);
    }

    public static ResourceObject<HugeElement> of(String graph, HugeElement elem) {
        ResourceType resType = ResourceType.from(elem.type());
        return new ResourceObject<HugeElement>(graph, resType, elem);
    }

    public static ResourceObject<SchemaDefine.UserElement> of(String graph, SchemaDefine.UserElement elem) {
        return new ResourceObject<SchemaDefine.UserElement>(graph, elem.type(), elem);
    }

    public static ResourceObject<?> of(String graph, ResourceType type, Namifiable elem) {
        return new ResourceObject<Namifiable>(graph, type, elem);
    }
}

