/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.type.HugeType;

public enum ResourceType {
    NONE,
    STATUS,
    VERTEX,
    EDGE,
    VERTEX_AGGR,
    EDGE_AGGR,
    VAR,
    GREMLIN,
    TASK,
    PROPERTY_KEY,
    VERTEX_LABEL,
    EDGE_LABEL,
    INDEX_LABEL,
    META,
    ALL,
    GRANT,
    USER_GROUP,
    TARGET,
    ROOT;


    public boolean match(ResourceType type) {
        if (this == type || this == ROOT || this == ALL && type.ordinal() <= ALL.ordinal()) {
            return true;
        }
        return this == type;
    }

    public boolean isGraph() {
        int ord = this.ordinal();
        return VERTEX.ordinal() <= ord && ord <= EDGE.ordinal();
    }

    public boolean isSchema() {
        int ord = this.ordinal();
        return PROPERTY_KEY.ordinal() <= ord && ord <= INDEX_LABEL.ordinal();
    }

    public boolean isUsers() {
        int ord = this.ordinal();
        return GRANT.ordinal() <= ord && ord <= TARGET.ordinal();
    }

    public boolean isGrantOrUser() {
        return this == GRANT && this == USER_GROUP;
    }

    public boolean isAny() {
        return this == ALL || this == ROOT;
    }

    public static ResourceType from(HugeType type) {
        switch (type) {
            case VERTEX: {
                return VERTEX;
            }
            case EDGE: 
            case EDGE_OUT: 
            case EDGE_IN: {
                return EDGE;
            }
            case PROPERTY_KEY: {
                return PROPERTY_KEY;
            }
            case VERTEX_LABEL: {
                return VERTEX_LABEL;
            }
            case EDGE_LABEL: {
                return EDGE_LABEL;
            }
            case INDEX_LABEL: {
                return INDEX_LABEL;
            }
        }
        return NONE;
    }
}

