/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.auth;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.auth.EntityManager;
import com.baidu.hugegraph.auth.HugeAccess;
import com.baidu.hugegraph.auth.HugeBelong;
import com.baidu.hugegraph.auth.HugeGroup;
import com.baidu.hugegraph.auth.HugePermission;
import com.baidu.hugegraph.auth.HugeTarget;
import com.baidu.hugegraph.auth.HugeUser;
import com.baidu.hugegraph.auth.RelationshipManager;
import com.baidu.hugegraph.auth.RolePermission;
import com.baidu.hugegraph.auth.SchemaDefine;
import com.baidu.hugegraph.auth.UserManager;
import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.CacheManager;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.event.Event;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.StringEncoding;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StandardUserManager
implements UserManager {
    private static final long CACHE_EXPIRE = Duration.ofDays(1L).toMillis();
    private final HugeGraphParams graph;
    private final EventListener eventListener;
    private final Cache<Id, HugeUser> usersCache;
    private final EntityManager<HugeUser> users;
    private final EntityManager<HugeGroup> groups;
    private final EntityManager<HugeTarget> targets;
    private final RelationshipManager<HugeBelong> belong;
    private final RelationshipManager<HugeAccess> access;

    public StandardUserManager(HugeGraphParams graph) {
        E.checkNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        this.eventListener = this.listenChanges();
        this.usersCache = this.cache("users");
        this.users = new EntityManager<HugeUser>(this.graph, HugeUser.P.USER, HugeUser::fromVertex);
        this.groups = new EntityManager<HugeGroup>(this.graph, HugeGroup.P.GROUP, HugeGroup::fromVertex);
        this.targets = new EntityManager<HugeTarget>(this.graph, HugeTarget.P.TARGET, HugeTarget::fromVertex);
        this.belong = new RelationshipManager<HugeBelong>(this.graph, HugeBelong.P.BELONG, HugeBelong::fromEdge);
        this.access = new RelationshipManager<HugeAccess>(this.graph, HugeAccess.P.ACCESS, HugeAccess::fromEdge);
    }

    private Cache<Id, HugeUser> cache(String prefix) {
        String name = prefix + "-" + this.graph.name();
        Cache<Id, HugeUser> cache = CacheManager.instance().cache(name);
        cache.expire(CACHE_EXPIRE);
        return cache;
    }

    private EventListener listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.inited");
        EventListener eventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        this.graph.loadSystemStore().provider().listen(eventListener);
        return eventListener;
    }

    private void unlistenChanges() {
        this.graph.loadSystemStore().provider().unlisten(this.eventListener);
    }

    @Override
    public boolean close() {
        this.unlistenChanges();
        return true;
    }

    private void initSchemaIfNeeded() {
        this.invalidCache();
        HugeUser.schema(this.graph).initSchemaIfNeeded();
        HugeGroup.schema(this.graph).initSchemaIfNeeded();
        HugeTarget.schema(this.graph).initSchemaIfNeeded();
        HugeBelong.schema(this.graph).initSchemaIfNeeded();
        HugeAccess.schema(this.graph).initSchemaIfNeeded();
    }

    private void invalidCache() {
        this.usersCache.clear();
    }

    @Override
    public Id createUser(HugeUser user) {
        this.invalidCache();
        return this.users.add(user);
    }

    @Override
    public Id updateUser(HugeUser user) {
        this.invalidCache();
        return this.users.update(user);
    }

    @Override
    public HugeUser deleteUser(Id id) {
        this.invalidCache();
        return this.users.delete(id);
    }

    @Override
    public HugeUser findUser(String name) {
        Id key = IdGenerator.of(name);
        HugeUser user = (HugeUser)this.usersCache.get(key);
        if (user != null) {
            return user;
        }
        List<HugeUser> users = this.users.query("~user_name", name, 2L);
        if (users.size() > 0) {
            assert (users.size() == 1);
            user = users.get(0);
            this.usersCache.update(key, user);
        }
        return user;
    }

    @Override
    public HugeUser getUser(Id id) {
        return this.users.get(id);
    }

    @Override
    public List<HugeUser> listUsers(List<Id> ids) {
        return this.users.list(ids);
    }

    @Override
    public List<HugeUser> listAllUsers(long limit) {
        return this.users.list(limit);
    }

    @Override
    public Id createGroup(HugeGroup group) {
        this.invalidCache();
        return this.groups.add(group);
    }

    @Override
    public Id updateGroup(HugeGroup group) {
        this.invalidCache();
        return this.groups.update(group);
    }

    @Override
    public HugeGroup deleteGroup(Id id) {
        this.invalidCache();
        return this.groups.delete(id);
    }

    @Override
    public HugeGroup getGroup(Id id) {
        return this.groups.get(id);
    }

    @Override
    public List<HugeGroup> listGroups(List<Id> ids) {
        return this.groups.list(ids);
    }

    @Override
    public List<HugeGroup> listAllGroups(long limit) {
        return this.groups.list(limit);
    }

    @Override
    public Id createTarget(HugeTarget target) {
        this.invalidCache();
        return this.targets.add(target);
    }

    @Override
    public Id updateTarget(HugeTarget target) {
        this.invalidCache();
        return this.targets.update(target);
    }

    @Override
    public HugeTarget deleteTarget(Id id) {
        this.invalidCache();
        return this.targets.delete(id);
    }

    @Override
    public HugeTarget getTarget(Id id) {
        return this.targets.get(id);
    }

    @Override
    public List<HugeTarget> listTargets(List<Id> ids) {
        return this.targets.list(ids);
    }

    @Override
    public List<HugeTarget> listAllTargets(long limit) {
        return this.targets.list(limit);
    }

    @Override
    public Id createBelong(HugeBelong belong) {
        this.invalidCache();
        E.checkArgument((boolean)this.users.exists(belong.source()), (String)"Not exists user '%s'", (Object[])new Object[]{belong.source()});
        E.checkArgument((boolean)this.groups.exists(belong.target()), (String)"Not exists group '%s'", (Object[])new Object[]{belong.target()});
        return this.belong.add(belong);
    }

    @Override
    public Id updateBelong(HugeBelong belong) {
        this.invalidCache();
        return this.belong.update(belong);
    }

    @Override
    public HugeBelong deleteBelong(Id id) {
        this.invalidCache();
        return this.belong.delete(id);
    }

    @Override
    public HugeBelong getBelong(Id id) {
        return this.belong.get(id);
    }

    @Override
    public List<HugeBelong> listBelong(List<Id> ids) {
        return this.belong.list(ids);
    }

    @Override
    public List<HugeBelong> listAllBelong(long limit) {
        return this.belong.list(limit);
    }

    @Override
    public List<HugeBelong> listBelongByUser(Id user, long limit) {
        return this.belong.list(user, Directions.OUT, HugeBelong.P.BELONG, limit);
    }

    @Override
    public List<HugeBelong> listBelongByGroup(Id group, long limit) {
        return this.belong.list(group, Directions.IN, HugeBelong.P.BELONG, limit);
    }

    @Override
    public Id createAccess(HugeAccess access) {
        this.invalidCache();
        E.checkArgument((boolean)this.groups.exists(access.source()), (String)"Not exists group '%s'", (Object[])new Object[]{access.source()});
        E.checkArgument((boolean)this.targets.exists(access.target()), (String)"Not exists target '%s'", (Object[])new Object[]{access.target()});
        return this.access.add(access);
    }

    @Override
    public Id updateAccess(HugeAccess access) {
        this.invalidCache();
        return this.access.update(access);
    }

    @Override
    public HugeAccess deleteAccess(Id id) {
        this.invalidCache();
        return this.access.delete(id);
    }

    @Override
    public HugeAccess getAccess(Id id) {
        return this.access.get(id);
    }

    @Override
    public List<HugeAccess> listAccess(List<Id> ids) {
        return this.access.list(ids);
    }

    @Override
    public List<HugeAccess> listAllAccess(long limit) {
        return this.access.list(limit);
    }

    @Override
    public List<HugeAccess> listAccessByGroup(Id group, long limit) {
        return this.access.list(group, Directions.OUT, HugeAccess.P.ACCESS, limit);
    }

    @Override
    public List<HugeAccess> listAccessByTarget(Id target, long limit) {
        return this.access.list(target, Directions.IN, HugeAccess.P.ACCESS, limit);
    }

    @Override
    public HugeUser matchUser(String name, String password) {
        E.checkArgumentNotNull((Object)name, (String)"User name can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)password, (String)"User password can't be null", (Object[])new Object[0]);
        HugeUser user = this.findUser(name);
        if (user != null && StringEncoding.checkPassword(password, user.password())) {
            return user;
        }
        return null;
    }

    @Override
    public RolePermission rolePermission(SchemaDefine.UserElement element) {
        if (element instanceof HugeUser) {
            return this.rolePermission((HugeUser)element);
        }
        if (element instanceof HugeTarget) {
            return this.rolePermission((HugeTarget)element);
        }
        ArrayList<HugeAccess> accesses = new ArrayList<HugeAccess>();
        if (element instanceof HugeBelong) {
            HugeBelong belong = (HugeBelong)element;
            accesses.addAll(this.listAccessByGroup(belong.target(), -1L));
        } else if (element instanceof HugeGroup) {
            HugeGroup group = (HugeGroup)element;
            accesses.addAll(this.listAccessByGroup(group.id(), -1L));
        } else if (element instanceof HugeAccess) {
            HugeAccess access = (HugeAccess)element;
            accesses.add(access);
        } else {
            E.checkArgument((boolean)false, (String)"Invalid type for role permission: %s", (Object[])new Object[]{element});
        }
        return this.rolePermission(accesses);
    }

    private RolePermission rolePermission(HugeUser user) {
        if (user.role() != null) {
            return user.role();
        }
        ArrayList<HugeAccess> accesses = new ArrayList<HugeAccess>();
        List<HugeBelong> belongs = this.listBelongByUser(user.id(), -1L);
        for (HugeBelong belong : belongs) {
            accesses.addAll(this.listAccessByGroup(belong.target(), -1L));
        }
        RolePermission role = this.rolePermission(accesses);
        user.role(role);
        return role;
    }

    private RolePermission rolePermission(List<HugeAccess> accesses) {
        RolePermission role = new RolePermission();
        for (HugeAccess access : accesses) {
            HugePermission accessPerm = access.permission();
            HugeTarget target = this.getTarget(access.target());
            role.add(target.graph(), accessPerm, target.resources());
        }
        return role;
    }

    private RolePermission rolePermission(HugeTarget target) {
        RolePermission role = new RolePermission();
        role.add(target.graph(), HugePermission.READ, target.resources());
        return role;
    }

    @Override
    public RolePermission loginUser(String username, String password) {
        HugeUser user = this.matchUser(username, password);
        if (user == null) {
            return null;
        }
        return this.rolePermission(user);
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            try {
                this.initSchemaIfNeeded();
            }
            finally {
                this.graph.closeTx();
            }
            return true;
        }
        return false;
    }
}

