/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.util.Log;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    public static final int MB = 0x100000;
    public static final int DEFAULT_SIZE = 0x100000;
    public static final int MAX_INIT_CAP = 0x6400000;
    public static final String ACTION_INVALID = "invalid";
    public static final String ACTION_CLEAR = "clear";
    protected static final Logger LOG = Log.logger(Cache.class);
    private volatile long hits = 0L;
    private volatile long miss = 0L;
    private volatile long expire = 0L;
    private final long capacity;
    private final long halfCapacity;
    private final AtomicReference<Object> attachment;

    public AbstractCache() {
        this(0x100000L);
    }

    public AbstractCache(long capacity) {
        if (capacity < 0L) {
            capacity = 0L;
        }
        this.capacity = capacity;
        this.halfCapacity = this.capacity >> 1;
        this.attachment = new AtomicReference();
    }

    @Override
    @PerfUtil.Watched(prefix="cache")
    public V get(K id) {
        if (id == null || this.capacity <= 0L) {
            return null;
        }
        V value = null;
        if (this.size() <= this.halfCapacity || this.containsKey(id)) {
            value = this.access(id);
        }
        if (value == null) {
            ++this.miss;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache missed '{}' (miss={}, hits={})", new Object[]{id, this.miss, this.hits});
            }
        } else {
            ++this.hits;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache cached '{}' (hits={}, miss={})", new Object[]{id, this.hits, this.miss});
            }
        }
        return value;
    }

    @Override
    @PerfUtil.Watched(prefix="cache")
    public V getOrFetch(K id, Function<K, V> fetcher) {
        if (id == null || this.capacity <= 0L) {
            return null;
        }
        V value = null;
        if (this.size() <= this.halfCapacity || this.containsKey(id)) {
            value = this.access(id);
        }
        if (value == null) {
            ++this.miss;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache missed '{}' (miss={}, hits={})", new Object[]{id, this.miss, this.hits});
            }
            value = fetcher.apply(id);
            this.update(id, value);
        } else {
            ++this.hits;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache cached '{}' (hits={}, miss={})", new Object[]{id, this.hits, this.miss});
            }
        }
        return value;
    }

    @Override
    @PerfUtil.Watched(prefix="cache")
    public boolean update(K id, V value) {
        if (id == null || value == null || this.capacity <= 0L) {
            return false;
        }
        return this.write(id, value);
    }

    @Override
    @PerfUtil.Watched(prefix="cache")
    public boolean updateIfAbsent(K id, V value) {
        if (id == null || value == null || this.capacity <= 0L || this.containsKey(id)) {
            return false;
        }
        return this.write(id, value);
    }

    @Override
    @PerfUtil.Watched(prefix="cache")
    public boolean updateIfPresent(K id, V value) {
        if (id == null || value == null || this.capacity <= 0L || !this.containsKey(id)) {
            return false;
        }
        return this.write(id, value);
    }

    @Override
    @PerfUtil.Watched(prefix="cache")
    public void invalidate(K id) {
        if (id == null || this.capacity <= 0L || !this.containsKey(id)) {
            return;
        }
        this.remove(id);
    }

    @Override
    public void expire(long ms) {
        this.expire = ms;
    }

    @Override
    public final long expire() {
        return this.expire;
    }

    @Override
    public long tick() {
        long expireTime = this.expire;
        if (expireTime <= 0L) {
            return 0L;
        }
        int expireItems = 0;
        long current = AbstractCache.now();
        Iterator<CacheNode<K, V>> it = this.nodes();
        while (it.hasNext()) {
            CacheNode<K, V> node = it.next();
            if (current - node.time() <= expireTime) continue;
            this.remove(node.key());
            ++expireItems;
        }
        if (expireItems > 0) {
            LOG.debug("Cache expired {} items cost {}ms (size {}, expire {}ms)", new Object[]{expireItems, AbstractCache.now() - current, this.size(), expireTime});
        }
        return expireItems;
    }

    @Override
    public final long hits() {
        return this.hits;
    }

    @Override
    public final long miss() {
        return this.miss;
    }

    @Override
    public final long capacity() {
        return this.capacity;
    }

    @Override
    public <T> T attachment(T object) {
        this.attachment.compareAndSet(null, object);
        return this.attachment();
    }

    @Override
    public <T> T attachment() {
        Object attachment = this.attachment.get();
        return (T)attachment;
    }

    protected final long halfCapacity() {
        return this.halfCapacity;
    }

    protected abstract V access(K var1);

    protected abstract boolean write(K var1, V var2);

    protected abstract void remove(K var1);

    protected abstract Iterator<CacheNode<K, V>> nodes();

    protected static final long now() {
        return System.currentTimeMillis();
    }

    protected static class CacheNode<K, V> {
        private final K key;
        private final V value;
        private long time;

        public CacheNode(K key, V value) {
            assert (key != null);
            this.time = AbstractCache.now();
            this.key = key;
            this.value = value;
        }

        public final K key() {
            return this.key;
        }

        public final V value() {
            return this.value;
        }

        public long time() {
            return this.time;
        }

        public String toString() {
            return this.key.toString();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheNode)) {
                return false;
            }
            CacheNode other = (CacheNode)object;
            return this.key.equals(other.key());
        }
    }
}

