/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.LevelCache;
import com.baidu.hugegraph.backend.cache.OffheapCache;
import com.baidu.hugegraph.backend.cache.RamCache;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class CacheManager {
    private static final Logger LOG = Log.logger(Cache.class);
    private static CacheManager INSTANCE = new CacheManager();
    private static final long TIMER_TICK_PERIOD = 30L;
    private static final long LOG_TICK_COST_TIME = 1000L;
    private final Map<String, Cache<Id, ?>> caches = new ConcurrentHashMap();
    private final Timer timer = new Timer("cache-expirer", true);

    public static CacheManager instance() {
        return INSTANCE;
    }

    public CacheManager() {
        this.scheduleTimer(30.0f);
    }

    private TimerTask scheduleTimer(float period) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    for (Map.Entry entry : CacheManager.this.caches().entrySet()) {
                        this.tick(entry.getKey(), entry.getValue());
                    }
                }
                catch (Throwable e) {
                    LOG.warn("An exception occurred when running tick", e);
                }
            }

            private void tick(String name, Cache<Id, Object> cache) {
                long start = System.currentTimeMillis();
                long items = cache.tick();
                long cost = System.currentTimeMillis() - start;
                if (cost > 1000L) {
                    LOG.info("Cache '{}' expired {} items cost {}ms > {}ms (size {}, expire {}ms)", new Object[]{name, items, cost, 1000L, cache.size(), cache.expire()});
                }
                LOG.debug("Cache '{}' expiration tick cost {}ms", (Object)name, (Object)cost);
            }
        };
        this.timer.schedule(task, 0L, (long)((double)period * 1000.0));
        return task;
    }

    public <V> Map<String, Cache<Id, V>> caches() {
        Map<String, Cache<Id, ?>> caches = this.caches;
        return Collections.unmodifiableMap(caches);
    }

    public <V> Cache<Id, V> cache(String name) {
        return this.cache(name, 0x100000L);
    }

    public <V> Cache<Id, V> cache(String name, long capacity) {
        if (!this.caches.containsKey(name)) {
            this.caches.putIfAbsent(name, new RamCache(capacity));
        }
        Cache<Id, ?> cache = this.caches.get(name);
        E.checkArgument((boolean)(cache instanceof RamCache), (String)"Invalid cache implement: %s", (Object[])new Object[]{cache.getClass()});
        return cache;
    }

    public <V> Cache<Id, V> offheapCache(HugeGraph graph, String name, long capacity, long avgElemSize) {
        OffheapCache cache;
        if (!this.caches.containsKey(name)) {
            cache = new OffheapCache(graph, capacity, avgElemSize);
            this.caches.putIfAbsent(name, cache);
        }
        cache = this.caches.get(name);
        E.checkArgument((boolean)(cache instanceof OffheapCache), (String)"Invalid cache implement: %s", (Object[])new Object[]{cache.getClass()});
        return cache;
    }

    public <V> Cache<Id, V> levelCache(HugeGraph graph, String name, long capacity1, long capacity2, long avgElemSize) {
        if (!this.caches.containsKey(name)) {
            RamCache cache1 = new RamCache(capacity1);
            OffheapCache cache2 = new OffheapCache(graph, capacity2, avgElemSize);
            this.caches.putIfAbsent(name, new LevelCache(cache1, cache2));
        }
        Cache<Id, ?> cache = this.caches.get(name);
        E.checkArgument((boolean)(cache instanceof LevelCache), (String)"Invalid cache implement: %s", (Object[])new Object[]{cache.getClass()});
        return cache;
    }
}

