/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.CacheManager;
import com.baidu.hugegraph.backend.cache.CachedBackendStore;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.ram.RamTable;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.event.Event;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.iterator.ListIterator;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.HugeType;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public final class CachedGraphTransaction
extends GraphTransaction {
    private static final int MAX_CACHE_PROPS_PER_VERTEX = 10000;
    private static final int MAX_CACHE_EDGES_PER_QUERY = 100;
    private static final float DEFAULT_LEVEL_RATIO = 0.001f;
    private static final long AVG_VERTEX_ENTRY_SIZE = 40L;
    private static final long AVG_EDGE_ENTRY_SIZE = 100L;
    private final Cache<Id, Object> verticesCache;
    private final Cache<Id, Object> edgesCache;
    private EventListener storeEventListener;
    private EventListener cacheEventListener;

    public CachedGraphTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        HugeConfig conf = graph.configuration();
        String type = (String)conf.get(CoreOptions.VERTEX_CACHE_TYPE);
        long capacity = (Long)conf.get(CoreOptions.VERTEX_CACHE_CAPACITY);
        int expire = (Integer)conf.get(CoreOptions.VERTEX_CACHE_EXPIRE);
        this.verticesCache = this.cache("vertex", type, capacity, 40L, expire);
        type = (String)conf.get(CoreOptions.EDGE_CACHE_TYPE);
        capacity = (Long)conf.get(CoreOptions.EDGE_CACHE_CAPACITY);
        expire = (Integer)conf.get(CoreOptions.EDGE_CACHE_EXPIRE);
        this.edgesCache = this.cache("edge", type, capacity, 100L, expire);
        this.listenChanges();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.unlistenChanges();
        }
    }

    private Cache<Id, Object> cache(String prefix, String type, long capacity, long entrySize, long expire) {
        Cache<Id, Object> cache;
        String name = prefix + "-" + this.params().name();
        switch (type) {
            case "l1": {
                cache = CacheManager.instance().cache(name, capacity);
                break;
            }
            case "l2": {
                long heapCapacity = (long)(0.001f * (float)capacity);
                cache = CacheManager.instance().levelCache(super.graph(), name, heapCapacity, capacity, entrySize);
                break;
            }
            default: {
                throw new NotSupportException("cache type '%s'", type);
            }
        }
        cache.expire(expire * 1000L);
        return cache;
    }

    private void listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.init", (Object)"store.clear", (Object)"store.truncate");
        this.storeEventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        this.store().provider().listen(this.storeEventListener);
        this.cacheEventListener = event -> {
            LOG.debug("Graph {} received graph cache event: {}", (Object)this.graph(), (Object)event);
            event.checkArgs(new Class[]{String.class, HugeType.class, Id.class});
            Object[] args = event.args();
            if ("invalid".equals(args[0])) {
                HugeType type = (HugeType)args[1];
                Id id = (Id)args[2];
                if (type.isVertex()) {
                    this.verticesCache.invalidate(id);
                } else if (type.isEdge()) {
                    this.edgesCache.clear();
                }
                return true;
            }
            if ("clear".equals(args[0])) {
                this.verticesCache.clear();
                this.edgesCache.clear();
                return true;
            }
            return false;
        };
        EventHub graphEventHub = this.params().graphEventHub();
        if (!graphEventHub.containsListener("cache")) {
            graphEventHub.listen("cache", this.cacheEventListener);
        }
    }

    private void unlistenChanges() {
        this.store().provider().unlisten(this.storeEventListener);
        EventHub graphEventHub = this.params().graphEventHub();
        graphEventHub.unlisten("cache", this.cacheEventListener);
    }

    @Override
    protected final Iterator<HugeVertex> queryVerticesFromBackend(Query query) {
        if (!query.ids().isEmpty() && query.conditions().isEmpty()) {
            return this.queryVerticesByIds((IdQuery)query);
        }
        return super.queryVerticesFromBackend(query);
    }

    private Iterator<HugeVertex> queryVerticesByIds(IdQuery query) {
        IdQuery newQuery = new IdQuery(HugeType.VERTEX, query);
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>();
        for (Id vertexId : query.ids()) {
            HugeVertex vertex = (HugeVertex)this.verticesCache.get(vertexId);
            if (vertex == null) {
                newQuery.query(vertexId);
                continue;
            }
            if (vertex.expired()) {
                newQuery.query(vertexId);
                this.verticesCache.invalidate(vertexId);
                continue;
            }
            vertices.add(vertex);
        }
        ExtendableIterator results = new ExtendableIterator();
        if (!vertices.isEmpty()) {
            results.extend(vertices.iterator());
        } else {
            newQuery = query;
        }
        if (!newQuery.empty()) {
            Iterator<HugeVertex> rs = super.queryVerticesFromBackend(newQuery);
            ListIterator<HugeVertex> listIterator = QueryResults.toList(rs);
            for (HugeVertex vertex : listIterator.list()) {
                if (vertex.sizeOfSubProperties() > 10000) continue;
                this.verticesCache.update(vertex.id(), vertex);
            }
            results.extend(listIterator);
        }
        return results;
    }

    @Override
    protected final Iterator<HugeEdge> queryEdgesFromBackend(Query query) {
        RamTable ramtable = this.params().ramtable();
        if (ramtable != null && ramtable.matched(query)) {
            return ramtable.query(query);
        }
        if (query.empty() || query.paging() || query.bigCapacity()) {
            return super.queryEdgesFromBackend(query);
        }
        CachedBackendStore.QueryId cacheKey = new CachedBackendStore.QueryId(query);
        Object value = this.edgesCache.get(cacheKey);
        ArrayList<HugeEdge> edges = (ArrayList<HugeEdge>)value;
        if (value != null) {
            for (HugeEdge edge : edges) {
                if (!edge.expired()) continue;
                this.edgesCache.invalidate(cacheKey);
                value = null;
            }
        }
        if (value != null) {
            return edges.iterator();
        }
        Iterator<HugeEdge> rs = super.queryEdgesFromBackend(query);
        int tryMax = 101;
        edges = new ArrayList<HugeEdge>(101);
        for (int i = 0; rs.hasNext() && i < 101; ++i) {
            edges.add(rs.next());
        }
        if (edges.size() == 0) {
            this.edgesCache.update(cacheKey, Collections.emptyList());
        } else if (edges.size() <= 100) {
            this.edgesCache.update(cacheKey, edges);
        }
        return new ExtendableIterator(edges.iterator(), rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void commitMutation2Backend(BackendMutation ... mutations) {
        Collection<HugeVertex> changes = this.verticesInTxUpdated();
        Collection<HugeVertex> deletions = this.verticesInTxRemoved();
        int edgesInTxSize = this.edgesInTxSize();
        try {
            super.commitMutation2Backend(mutations);
            for (HugeVertex vertex : changes) {
                if (vertex.sizeOfSubProperties() > 10000) {
                    this.verticesCache.invalidate(vertex.id());
                    continue;
                }
                this.verticesCache.updateIfPresent(vertex.id(), vertex);
            }
        }
        finally {
            for (HugeVertex vertex : deletions) {
                this.verticesCache.invalidate(vertex.id());
            }
            if (edgesInTxSize > 0) {
                this.edgesCache.clear();
            }
        }
    }

    @Override
    public final void removeIndex(IndexLabel indexLabel) {
        try {
            super.removeIndex(indexLabel);
        }
        finally {
            if (indexLabel.baseType() == HugeType.EDGE_LABEL) {
                this.edgesCache.clear();
            }
        }
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            LOG.debug("Graph {} clear graph cache on event '{}'", (Object)this.graph(), (Object)event.name());
            this.verticesCache.clear();
            this.edgesCache.clear();
            return true;
        }
        return false;
    }
}

